/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.event.response.blocking;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.SharedData;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.jacpfx.common.ExecutionResult;
import org.jacpfx.common.throwable.ThrowableFunction;
import org.jacpfx.common.throwable.ThrowableSupplier;
import org.jacpfx.vertx.event.response.basic.ResponseExecution;

public class ResponseBlockingExecution {
    private static final int DEFAULT_VALUE = 0;
    private static final long DEFAULT_LONG_VALUE = 0L;
    private static final int DEFAULT_LOCK_TIMEOUT = 2000;
    private static final int STOP_CONDITION = -1;
    private static final long LOCK_VALUE = -1L;

    public static <T> void createResponseBlocking(String methodId, ThrowableSupplier<T> supplier, Future<ExecutionResult<T>> blockingHandler, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Vertx vertx, Throwable failure, int retry, long timeout, long circuitBreakerTimeout, long delay) {
        if (circuitBreakerTimeout > 0L) {
            ResponseBlockingExecution.executeLocked((lock, counter) -> counter.get(counterHandler -> {
                long currentVal = (Long)counterHandler.result();
                if (currentVal == 0L) {
                    ResponseBlockingExecution.executeInitialState(methodId, supplier, blockingHandler, errorHandler, onFailureRespond, errorMethodHandler, vertx, failure, retry, timeout, circuitBreakerTimeout, delay, lock, counter);
                } else if (currentVal > 0L) {
                    ResponseBlockingExecution.executeDefault(methodId, supplier, blockingHandler, errorHandler, onFailureRespond, errorMethodHandler, vertx, failure, retry, timeout, circuitBreakerTimeout, delay, lock);
                } else {
                    ResponseBlockingExecution.executeErrorState(blockingHandler, errorHandler, onFailureRespond, errorMethodHandler, failure, lock);
                }
            }), methodId, vertx, blockingHandler, errorHandler, onFailureRespond, errorMethodHandler, null);
        } else {
            ResponseBlockingExecution.executeStateless(supplier, blockingHandler, errorHandler, onFailureRespond, errorMethodHandler, vertx, retry, timeout, delay);
        }
    }

    private static <T> void executeErrorState(Future<ExecutionResult<T>> _blockingHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Throwable failure, Lock lock) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        ResponseBlockingExecution.handleErrorExecution(_blockingHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, Optional.ofNullable(failure).orElse(Future.failedFuture((String)"circuit open").cause()));
    }

    private static <T> void executeDefault(String _methodId, ThrowableSupplier<T> _supplier, Future<ExecutionResult<T>> _blockingHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Vertx vertx, Throwable _failure, int _retry, long _timeout, long _circuitBreakerTimeout, long _delay, Lock lock) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        vertx.executeBlocking(bhandler -> {
            try {
                ResponseBlockingExecution.executeDefaultState(_supplier, _blockingHandler, vertx, _timeout);
                bhandler.complete();
            }
            catch (Throwable e) {
                ResponseBlockingExecution.executeLocked((lck, counter) -> counter.decrementAndGet(valHandler -> {
                    if (valHandler.succeeded()) {
                        ResponseBlockingExecution.handleStatefulError(_methodId, _supplier, _blockingHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, vertx, _failure, _retry, _timeout, _circuitBreakerTimeout, _delay, e, lck, counter, (AsyncResult<Long>)valHandler);
                        bhandler.complete();
                    } else {
                        ResponseBlockingExecution.releaseLockAndHandleError(_blockingHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, valHandler.cause(), lck);
                        bhandler.complete();
                    }
                }), _methodId, vertx, _blockingHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, bhandler);
            }
        }, false, res -> {});
    }

    private static <T> void executeInitialState(String _methodId, ThrowableSupplier<T> _supplier, Future<ExecutionResult<T>> _blockingHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Vertx vertx, Throwable _t, int _retry, long _timeout, long _circuitBreakerTimeout, long _delay, Lock lock, Counter counter) {
        long initialRetryCounterValue = _retry + 1;
        counter.addAndGet(initialRetryCounterValue, rHandler -> ResponseBlockingExecution.executeDefault(_methodId, _supplier, _blockingHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, vertx, _t, _retry, _timeout, _circuitBreakerTimeout, _delay, lock));
    }

    private static <T> void releaseLockAndHandleError(Future<ExecutionResult<T>> _blockingHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Throwable cause, Lock lock) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        ResponseBlockingExecution.handleErrorExecution(_blockingHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, cause);
    }

    private static <T> void handleErrorExecution(Future<ExecutionResult<T>> _blockingHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Throwable cause) {
        Object result = null;
        result = ResponseBlockingExecution.handleError(result, _errorHandler, _onFailureRespond, _errorMethodHandler, cause);
        if (!_blockingHandler.isComplete()) {
            _blockingHandler.complete((Object)new ExecutionResult(result, true, true, null));
        }
    }

    private static <T> void handleStatefulError(String _methodId, ThrowableSupplier<T> _supplier, Future<ExecutionResult<T>> _blockingHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Vertx vertx, Throwable _t, int _retry, long _timeout, long _circuitBreakerTimeout, long _delay, Throwable e, Lock lck, Counter counter, AsyncResult<Long> valHandler) {
        long count = (Long)valHandler.result();
        if (count <= 0L) {
            ResponseBlockingExecution.setCircuitBreakerReleaseTimer(vertx, _retry, _circuitBreakerTimeout, counter);
            ResponseBlockingExecution.openCircuitBreakerAndHandleError(_blockingHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, vertx, e, lck, counter);
        } else {
            lck.release();
            ResponseExecution.handleError(_errorHandler, e);
            ResponseBlockingExecution.handleDelay(_delay);
            ResponseBlockingExecution.createResponseBlocking(_methodId, _supplier, _blockingHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, vertx, _t, _retry, _timeout, _circuitBreakerTimeout, _delay);
        }
    }

    private static <T> void openCircuitBreakerAndHandleError(Future<ExecutionResult<T>> _blockingHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Vertx vertx, Throwable e, Lock lck, Counter counter) {
        counter.addAndGet(-1L, val -> {
            lck.release();
            vertx.executeBlocking(bhandler -> {
                Object result = null;
                result = ResponseBlockingExecution.handleError(result, _errorHandler, _onFailureRespond, _errorMethodHandler, e);
                if (!_blockingHandler.isComplete()) {
                    _blockingHandler.complete((Object)new ExecutionResult(result, true, true, null));
                }
            }, false, res -> {});
        });
    }

    private static void setCircuitBreakerReleaseTimer(Vertx vertx, int _retry, long _circuitBreakerTimeout, Counter counter) {
        long initialRetryCounterValue = _retry + 1;
        vertx.setTimer(_circuitBreakerTimeout, timer -> counter.addAndGet(initialRetryCounterValue, val -> {}));
    }

    private static <T> void executeDefaultState(ThrowableSupplier<T> _supplier, Future<ExecutionResult<T>> _blockingHandler, Vertx vertx, long _timeout) throws Throwable {
        Object result = _timeout > 0L ? ResponseBlockingExecution.executeWithTimeout(_supplier, vertx, _timeout) : _supplier.get();
        if (!_blockingHandler.isComplete()) {
            _blockingHandler.complete((Object)new ExecutionResult(result, true, false, null));
        }
    }

    private static <T> T executeWithTimeout(ThrowableSupplier<T> _supplier, Vertx vertx, long _timeout) throws Throwable {
        Object result;
        CompletableFuture timeoutFuture = new CompletableFuture();
        vertx.executeBlocking(innerHandler -> {
            try {
                timeoutFuture.complete(_supplier.get());
            }
            catch (Throwable throwable) {
                timeoutFuture.obtrudeException(throwable);
            }
        }, false, val -> {});
        try {
            result = timeoutFuture.get(_timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeout) {
            throw new TimeoutException("operation _timeout");
        }
        return result;
    }

    private static <T> void executeStateless(ThrowableSupplier<T> _supplier, Future<ExecutionResult<T>> _blockingHandler, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Vertx vertx, int _retry, long timeout, long delay) {
        Object result = null;
        boolean errorHandling = false;
        while (_retry >= 0) {
            errorHandling = false;
            try {
                if (timeout > 0L) {
                    result = ResponseBlockingExecution.executeWithTimeout(_supplier, vertx, timeout);
                    _retry = -1;
                    continue;
                }
                result = _supplier.get();
                _retry = -1;
            }
            catch (Throwable e) {
                if (--_retry < 0) {
                    try {
                        result = ResponseBlockingExecution.handleError(result, errorHandler, onFailureRespond, errorMethodHandler, e);
                        errorHandling = true;
                    }
                    catch (Exception ee) {
                        _blockingHandler.fail((Throwable)ee);
                    }
                    continue;
                }
                ResponseExecution.handleError(errorHandler, e);
                ResponseBlockingExecution.handleDelay(delay);
            }
        }
        if ((!errorHandling || errorHandling && result != null) && !_blockingHandler.isComplete()) {
            _blockingHandler.complete((Object)new ExecutionResult(result, true, errorHandling, null));
        }
    }

    private static void handleDelay(long delay) {
        try {
            if (delay > 0L) {
                Thread.sleep(delay);
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    private static <T> T handleError(T result, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Throwable e) {
        try {
            if (errorHandler != null) {
                errorHandler.accept(e);
            }
            if (onFailureRespond != null) {
                result = onFailureRespond.apply((Object)e);
            }
            if (errorHandler == null && onFailureRespond == null) {
                errorMethodHandler.accept(e);
                return null;
            }
        }
        catch (Throwable throwable) {
            errorMethodHandler.accept(throwable);
        }
        return result;
    }

    private static <T, U> void executeLocked(LockedConsumer consumer, String _methodId, Vertx vertx, Future<ExecutionResult<T>> _blockingHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Future<U> blockingCodeHandler) {
        SharedData sharedData = vertx.sharedData();
        sharedData.getLockWithTimeout(_methodId, 2000L, lockHandler -> {
            Lock lock = (Lock)lockHandler.result();
            if (lockHandler.succeeded()) {
                sharedData.getCounter(_methodId, resultHandler -> {
                    if (resultHandler.succeeded()) {
                        consumer.execute(lock, (Counter)resultHandler.result());
                    } else {
                        ResponseBlockingExecution.releaseLockAndHandleError(_blockingHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, resultHandler.cause(), lock);
                        Optional.ofNullable(blockingCodeHandler).ifPresent(Future::complete);
                    }
                });
            } else {
                ResponseBlockingExecution.handleErrorExecution(_blockingHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, lockHandler.cause());
                Optional.ofNullable(blockingCodeHandler).ifPresent(Future::complete);
            }
        });
    }

    private static interface LockedConsumer {
        public void execute(Lock var1, Counter var2);
    }
}

