/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.event.eventbus.blocking;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import java.util.Optional;
import java.util.function.Consumer;
import org.jacpfx.common.VxmsShared;
import org.jacpfx.common.concurrent.LocalData;
import org.jacpfx.common.encoder.Encoder;
import org.jacpfx.common.throwable.ThrowableFunction;
import org.jacpfx.common.throwable.ThrowableSupplier;
import org.jacpfx.vertx.event.interfaces.blocking.RecursiveBlockingExecutor;
import org.jacpfx.vertx.event.interfaces.blocking.RetryBlockingExecutor;
import org.jacpfx.vertx.event.response.basic.ResponseExecution;

public class EventbusBridgeBlockingExecution {
    private static final long LOCK_VALUE = -1L;
    private static final int DEFAULT_LOCK_TIMEOUT = 2000;
    private static final long NO_TIMEOUT = 0L;

    public static <T> void sendMessageAndSupplyHandler(String methodId, String targetId, Object message, ThrowableFunction<AsyncResult<Message<Object>>, T> function, DeliveryOptions deliveryOptions, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor, RetryBlockingExecutor retryExecutor) {
        if (circuitBreakerTimeout == 0L) {
            EventbusBridgeBlockingExecution.executeDefaultState(targetId, message, function, deliveryOptions, methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, retryExecutor, null);
        } else {
            EventbusBridgeBlockingExecution.executeStateful(targetId, message, function, deliveryOptions, methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, retryExecutor);
        }
    }

    private static <T> void executeStateful(String targetId, Object message, ThrowableFunction<AsyncResult<Message<Object>>, T> byteFunction, DeliveryOptions deliveryOptions, String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor, RetryBlockingExecutor retry) {
        EventbusBridgeBlockingExecution.executeLocked((lock, counter) -> counter.get(counterHandler -> {
            long currentVal = (Long)counterHandler.result();
            if (currentVal == 0L) {
                EventbusBridgeBlockingExecution.executeInitialState(targetId, message, byteFunction, deliveryOptions, methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, retry, lock, counter);
            } else if (currentVal > 0L) {
                EventbusBridgeBlockingExecution.executeDefaultState(targetId, message, byteFunction, deliveryOptions, methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, retry, lock);
            } else {
                EventbusBridgeBlockingExecution.executeErrorState(methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, lock);
            }
        }), methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor);
    }

    private static <T> void executeInitialState(String targetId, Object message, ThrowableFunction<AsyncResult<Message<Object>>, T> byteFunction, DeliveryOptions deliveryOptions, String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor, RetryBlockingExecutor retry, Lock lock, Counter counter) {
        int incrementCounter = retryCount + 1;
        counter.addAndGet(Integer.valueOf(incrementCounter).longValue(), rHandler -> EventbusBridgeBlockingExecution.executeDefaultState(targetId, message, byteFunction, deliveryOptions, methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, retry, lock));
    }

    private static <T> void executeDefaultState(String targetId, Object message, ThrowableFunction<AsyncResult<Message<Object>>, T> function, DeliveryOptions deliveryOptions, String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor, RetryBlockingExecutor retry, Lock lock) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        Vertx vertx = vxmsShared.getVertx();
        vertx.eventBus().send(targetId, message, deliveryOptions, event -> EventbusBridgeBlockingExecution.createSupplierAndExecute(targetId, message, function, deliveryOptions, methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, retry, (AsyncResult<Message<Object>>)event));
    }

    private static <T> void executeErrorState(String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor, Lock lock) {
        Throwable cause = Future.failedFuture((String)"circuit open").cause();
        EventbusBridgeBlockingExecution.handleError(methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, lock, cause);
    }

    private static <T> void createSupplierAndExecute(String targetId, Object message, ThrowableFunction<AsyncResult<Message<Object>>, T> function, DeliveryOptions deliveryOptions, String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor, RetryBlockingExecutor retry, AsyncResult<Message<Object>> event) {
        ThrowableSupplier<T> supplier = EventbusBridgeBlockingExecution.createSupplier(targetId, message, function, deliveryOptions, methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, retry, event);
        if (circuitBreakerTimeout == 0L) {
            EventbusBridgeBlockingExecution.statelessExecution(targetId, message, function, deliveryOptions, methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, retry, event, supplier);
        } else {
            EventbusBridgeBlockingExecution.statefulExecution(targetId, message, function, deliveryOptions, methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, retry, event, supplier);
        }
    }

    private static <T> void statelessExecution(String targetId, Object message, ThrowableFunction<AsyncResult<Message<Object>>, T> function, DeliveryOptions deliveryOptions, String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor, RetryBlockingExecutor retry, AsyncResult<Message<Object>> event, ThrowableSupplier<T> byteSupplier) {
        if (event.succeeded() || event.failed() && retryCount <= 0) {
            executor.execute(methodId, vxmsShared, event.cause(), errorMethodHandler, requestMessage, byteSupplier, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout);
        } else if (event.failed() && retryCount > 0) {
            EventbusBridgeBlockingExecution.retryFunction(targetId, message, function, deliveryOptions, methodId, vxmsShared, event.cause(), errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, retry);
        }
    }

    private static <T> void statefulExecution(String targetId, Object message, ThrowableFunction<AsyncResult<Message<Object>>, T> function, DeliveryOptions deliveryOptions, String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor, RetryBlockingExecutor retry, AsyncResult<Message<Object>> event, ThrowableSupplier<T> supplier) {
        if (event.succeeded()) {
            executor.execute(methodId, vxmsShared, event.cause(), errorMethodHandler, requestMessage, supplier, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout);
        } else {
            EventbusBridgeBlockingExecution.statefulErrorHandling(targetId, message, function, deliveryOptions, methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, retry, event);
        }
    }

    private static <T> void statefulErrorHandling(String targetId, Object message, ThrowableFunction<AsyncResult<Message<Object>>, T> function, DeliveryOptions deliveryOptions, String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor, RetryBlockingExecutor retry, AsyncResult<Message<Object>> event) {
        EventbusBridgeBlockingExecution.executeLocked((lock, counter) -> counter.decrementAndGet(valHandler -> {
            if (valHandler.succeeded()) {
                long count = (Long)valHandler.result();
                if (count <= 0L) {
                    EventbusBridgeBlockingExecution.openCircuitAndHandleError(methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, event, lock, counter);
                } else {
                    lock.release();
                    Throwable cause = event.cause();
                    EventbusBridgeBlockingExecution.retryFunction(targetId, message, function, deliveryOptions, methodId, vxmsShared, cause, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, retry);
                }
            } else {
                Throwable cause = valHandler.cause();
                EventbusBridgeBlockingExecution.handleError(methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, lock, cause);
            }
        }), methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor);
    }

    private static <T> void openCircuitAndHandleError(String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor, AsyncResult<Message<Object>> event, Lock lock, Counter counter) {
        EventbusBridgeBlockingExecution.resetLockTimer(vxmsShared, retryCount, circuitBreakerTimeout, counter);
        EventbusBridgeBlockingExecution.lockAndHandle(counter, (Handler<AsyncResult<Long>>)((Handler)val -> {
            Throwable cause = event.cause();
            EventbusBridgeBlockingExecution.handleError(methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, lock, cause);
        }));
    }

    private static void lockAndHandle(Counter counter, Handler<AsyncResult<Long>> asyncResultHandler) {
        counter.addAndGet(-1L, asyncResultHandler);
    }

    private static void resetLockTimer(VxmsShared vxmsShared, int retryCount, long circuitBreakerTimeout, Counter counter) {
        Vertx vertx = vxmsShared.getVertx();
        vertx.setTimer(circuitBreakerTimeout, timer -> counter.addAndGet(Integer.valueOf(retryCount + 1).longValue(), val -> {}));
    }

    private static <T> void handleError(String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor, Lock lock, Throwable cause) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        ThrowableSupplier failConsumer = () -> {
            assert (cause != null);
            throw cause;
        };
        executor.execute(methodId, vxmsShared, cause, errorMethodHandler, requestMessage, failConsumer, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout);
    }

    private static <T> void retryFunction(String targetId, Object message, ThrowableFunction<AsyncResult<Message<Object>>, T> function, DeliveryOptions requestDeliveryOptions, String methodId, VxmsShared vxmsShared, Throwable failure, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RetryBlockingExecutor retry) {
        ResponseExecution.handleError(errorHandler, failure);
        retry.execute(methodId, targetId, message, function, requestDeliveryOptions, vxmsShared, failure, errorMethodHandler, requestMessage, null, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout);
    }

    private static <T> ThrowableSupplier<T> createSupplier(String targetId, Object message, ThrowableFunction<AsyncResult<Message<Object>>, T> function, DeliveryOptions deliveryOptions, String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RetryBlockingExecutor retry, AsyncResult<Message<Object>> event) {
        return () -> {
            Object resp = null;
            if (!event.failed()) return function.apply((Object)event);
            if (retryCount <= 0) throw event.cause();
            EventbusBridgeBlockingExecution.retryFunction(targetId, message, function, deliveryOptions, methodId, vxmsShared, event.cause(), errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, retry);
            return resp;
        };
    }

    private static <T> void executeLocked(LockedConsumer consumer, String methodId, VxmsShared vxmsShared, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout, RecursiveBlockingExecutor executor) {
        LocalData sharedData = vxmsShared.getLocalData();
        sharedData.getLockWithTimeout(methodId, 2000L, lockHandler -> {
            if (lockHandler.succeeded()) {
                Lock lock = (Lock)lockHandler.result();
                sharedData.getCounter(methodId, resultHandler -> {
                    if (resultHandler.succeeded()) {
                        consumer.execute(lock, (Counter)resultHandler.result());
                    } else {
                        Throwable cause = resultHandler.cause();
                        EventbusBridgeBlockingExecution.handleError(methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, lock, cause);
                    }
                });
            } else {
                Throwable cause = lockHandler.cause();
                EventbusBridgeBlockingExecution.handleError(methodId, vxmsShared, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, delay, circuitBreakerTimeout, executor, null, cause);
            }
        });
    }

    private static interface LockedConsumer {
        public void execute(Lock var1, Counter var2);
    }
}

