/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.event.response.basic;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.jacpfx.common.ExecutionResult;
import org.jacpfx.common.VxmsShared;
import org.jacpfx.common.concurrent.LocalData;
import org.jacpfx.common.encoder.Encoder;
import org.jacpfx.common.throwable.ThrowableErrorConsumer;
import org.jacpfx.common.throwable.ThrowableFutureConsumer;

public class ResponseExecution {
    private static final int DEFAULT_VALUE = 0;
    private static final long DEFAULT_LONG_VALUE = 0L;
    private static final int DEFAULT_LOCK_TIMEOUT = 2000;
    private static final long LOCK_VALUE = -1L;

    public static <T> void createResponse(String methodId, int retry, long timeout, long circuitBreakerTimeout, ThrowableFutureConsumer<T> userOperation, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Throwable failure, Consumer<ExecutionResult<T>> resultConsumer) {
        if (circuitBreakerTimeout > 0L) {
            ResponseExecution.executeStateful(methodId, retry, timeout, circuitBreakerTimeout, userOperation, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, failure, resultConsumer);
        } else {
            ResponseExecution.executeStateless(methodId, retry, timeout, circuitBreakerTimeout, userOperation, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer);
        }
    }

    private static <T> void executeStateless(String _methodId, int _retry, long _timeout, long _release, ThrowableFutureConsumer<T> _userOperation, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Consumer<ExecutionResult<T>> resultConsumer) {
        Future operationResult = Future.future();
        operationResult.setHandler(event -> {
            if (event.failed()) {
                int retryTemp = _retry - 1;
                ResponseExecution.retryOrFail(_methodId, _timeout, _release, _userOperation, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer, event, retryTemp);
            } else {
                resultConsumer.accept(new ExecutionResult(event.result(), true, null));
            }
        });
        if (_timeout > 0L) {
            ResponseExecution.addTimeoutHandler(_timeout, vxmsShared, (Handler<Long>)((Handler)l -> {
                if (!operationResult.isComplete()) {
                    operationResult.fail((Throwable)new TimeoutException("operation timeout"));
                }
            }));
        }
        ResponseExecution.executeAndCompleate(_userOperation, operationResult);
    }

    private static <T> void executeAndCompleate(ThrowableFutureConsumer<T> userOperation, Future<T> operationResult) {
        try {
            userOperation.accept(operationResult);
        }
        catch (Throwable throwable) {
            operationResult.fail(throwable);
        }
    }

    private static <T> void retryOrFail(String _methodId, long _timeout, long _release, ThrowableFutureConsumer<T> _userOperation, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Consumer<ExecutionResult<T>> resultConsumer, AsyncResult<T> event, int retryTemp) {
        if (retryTemp < 0) {
            ResponseExecution.errorHandling(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, event);
        } else {
            ResponseExecution.retry(_methodId, retryTemp, _timeout, _release, _userOperation, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer, event);
        }
    }

    private static <T> void executeStateful(String _methodId, int _retry, long _timeout, long _circuitBreakerTimeout, ThrowableFutureConsumer<T> _userOperation, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Throwable t, Consumer<ExecutionResult<T>> resultConsumer) {
        Future operationResult = Future.future();
        operationResult.setHandler(event -> {
            if (event.failed()) {
                ResponseExecution.statefulErrorHandling(_methodId, _retry, _timeout, _circuitBreakerTimeout, _userOperation, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer, event);
            } else {
                resultConsumer.accept(new ExecutionResult(event.result(), true, null));
            }
        });
        ResponseExecution.executeLocked((lock, counter) -> counter.get(counterHandler -> {
            long currentVal = (Long)counterHandler.result();
            if (currentVal == 0L) {
                ResponseExecution.executeInitialState(_retry, _timeout, _userOperation, vxmsShared, operationResult, lock, counter);
            } else if (currentVal > 0L) {
                ResponseExecution.executeDefaultState(_timeout, _userOperation, vxmsShared, operationResult, lock);
            } else {
                ResponseExecution.releaseLockAndHandleError(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, lock, Optional.ofNullable(t).orElse(Future.failedFuture((String)"circuit open").cause()));
            }
        }), _methodId, vxmsShared, errorHandler, onFailureRespond, errorMethodHandler, resultConsumer);
    }

    private static <T> void releaseLockAndHandleError(Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Consumer<ExecutionResult<T>> resultConsumer, Lock lock, Throwable cause) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        ResponseExecution.errorHandling(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, Future.failedFuture((Throwable)cause));
    }

    private static <T> void executeDefaultState(long _timeout, ThrowableFutureConsumer<T> _userOperation, VxmsShared vxmsShared, Future<T> operationResult, Lock lock) {
        lock.release();
        if (_timeout > 0L) {
            ResponseExecution.addTimeoutHandler(_timeout, vxmsShared, (Handler<Long>)((Handler)l -> {
                if (!operationResult.isComplete()) {
                    operationResult.fail((Throwable)new TimeoutException("operation timeout"));
                }
            }));
        }
        ResponseExecution.executeAndCompleate(_userOperation, operationResult);
    }

    private static <T> void executeInitialState(int _retry, long _timeout, ThrowableFutureConsumer<T> _userOperation, VxmsShared vxmsShared, Future<T> operationResult, Lock lock, Counter counter) {
        long initialRetryCounterValue = _retry + 1;
        counter.addAndGet(initialRetryCounterValue, rHandler -> ResponseExecution.executeDefaultState(_timeout, _userOperation, vxmsShared, operationResult, lock));
    }

    private static <T> void statefulErrorHandling(String _methodId, int _retry, long _timeout, long _circuitBreakerTimeout, ThrowableFutureConsumer<T> _userOperation, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Consumer<ExecutionResult<T>> resultConsumer, AsyncResult<T> event) {
        ResponseExecution.executeLocked((lock, counter) -> counter.decrementAndGet(valHandler -> {
            if (valHandler.succeeded()) {
                ResponseExecution.handleStatefulError(_methodId, _retry, _timeout, _circuitBreakerTimeout, _userOperation, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer, event, lock, counter, (AsyncResult<Long>)valHandler);
            } else {
                ResponseExecution.releaseLockAndHandleError(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, lock, valHandler.cause());
            }
        }), _methodId, vxmsShared, errorHandler, onFailureRespond, errorMethodHandler, resultConsumer);
    }

    private static <T> void handleStatefulError(String _methodId, int _retry, long _timeout, long _circuitBreakerTimeout, ThrowableFutureConsumer<T> _userOperation, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Consumer<ExecutionResult<T>> resultConsumer, AsyncResult<T> event, Lock lock, Counter counter, AsyncResult<Long> valHandler) {
        long count = (Long)valHandler.result();
        if (count <= 0L) {
            ResponseExecution.setCircuitBreakerReleaseTimer(_retry, _circuitBreakerTimeout, vxmsShared, counter);
            ResponseExecution.openCircuitBreakerAndHandleError(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, event, lock, counter);
        } else {
            lock.release();
            ResponseExecution.retry(_methodId, _retry, _timeout, _circuitBreakerTimeout, _userOperation, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer, event);
        }
    }

    private static <T> void openCircuitBreakerAndHandleError(Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Consumer<ExecutionResult<T>> resultConsumer, AsyncResult<T> event, Lock lock, Counter counter) {
        counter.addAndGet(-1L, val -> {
            lock.release();
            ResponseExecution.errorHandling(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, Future.failedFuture((Throwable)event.cause()));
        });
    }

    private static void setCircuitBreakerReleaseTimer(int _retry, long _release, VxmsShared vxmsShared, Counter counter) {
        long initialRetryCounterValue = _retry + 1;
        Vertx vertx = vxmsShared.getVertx();
        vertx.setTimer(_release, timer -> counter.addAndGet(initialRetryCounterValue, val -> {}));
    }

    private static void addTimeoutHandler(long _timeout, VxmsShared vxmsShared, Handler<Long> longHandler) {
        Vertx vertx = vxmsShared.getVertx();
        vertx.setTimer(_timeout, longHandler);
    }

    private static <T> void errorHandling(Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Consumer<ExecutionResult<T>> resultConsumer, AsyncResult<T> event) {
        try {
            Future errorResult = Future.future();
            errorResult.setHandler(resultHandler -> {
                if (resultHandler.succeeded()) {
                    resultConsumer.accept(new ExecutionResult(resultHandler.result(), true, true, null));
                } else {
                    ResponseExecution.handleExecutionError(null, errorHandler, null, errorMethodHandler, resultHandler.cause());
                }
            });
            ResponseExecution.handleExecutionError(errorResult, errorHandler, onFailureRespond, errorMethodHandler, event.cause());
        }
        catch (Exception e) {
            resultConsumer.accept(new ExecutionResult(null, false, (Throwable)e));
        }
    }

    private static <T> void retry(String _methodId, int retryTemp, long _timeout, long _release, ThrowableFutureConsumer<T> _userOperation, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Consumer<ExecutionResult<T>> resultConsumer, AsyncResult<T> event) {
        ResponseExecution.handleError(errorHandler, event.cause());
        ResponseExecution.createResponse(_methodId, retryTemp, _timeout, _release, _userOperation, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, null, resultConsumer);
    }

    private static <T> void handleExecutionError(Future<T> errorResult, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Throwable e) {
        ResponseExecution.handleError(errorHandler, e);
        try {
            if (onFailureRespond != null) {
                onFailureRespond.accept((Object)e, errorResult);
            } else {
                errorMethodHandler.accept(e);
            }
        }
        catch (Throwable throwable) {
            errorResult.fail(throwable);
        }
    }

    public static void handleError(Consumer<Throwable> errorHandler, Throwable e) {
        if (errorHandler != null) {
            errorHandler.accept(e);
        }
    }

    public static Optional<?> encode(Serializable value, Encoder encoder) {
        try {
            if (encoder instanceof Encoder.ByteEncoder) {
                return Optional.ofNullable(((Encoder.ByteEncoder)encoder).encode((Object)value));
            }
            if (encoder instanceof Encoder.StringEncoder) {
                return Optional.ofNullable(((Encoder.StringEncoder)encoder).encode((Object)value));
            }
            return Optional.ofNullable(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private static <T> void executeLocked(LockedConsumer consumer, String _methodId, VxmsShared vxmsShared, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Consumer<ExecutionResult<T>> resultConsumer) {
        LocalData sharedData = vxmsShared.getLocalData();
        sharedData.getLockWithTimeout(_methodId, 2000L, lockHandler -> {
            Lock lock = (Lock)lockHandler.result();
            if (lockHandler.succeeded()) {
                sharedData.getCounter(_methodId, resultHandler -> {
                    if (resultHandler.succeeded()) {
                        consumer.execute(lock, (Counter)resultHandler.result());
                    } else {
                        ResponseExecution.releaseLockAndHandleError(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, lock, resultHandler.cause());
                    }
                });
            } else {
                ResponseExecution.releaseLockAndHandleError(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, lock, lockHandler.cause());
            }
        });
    }

    private static interface LockedConsumer {
        public void execute(Lock var1, Counter var2);
    }
}

