/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.event.eventbus.basic;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Optional;
import java.util.function.Consumer;
import org.jacpfx.common.VxmsShared;
import org.jacpfx.vertx.event.eventbus.basic.EventbusBridgeResponse;
import org.jacpfx.vertx.event.eventbus.blocking.EventbusBridgeBlockingRequest;

public class EventbusBridgeRequest {
    private final String methodId;
    private final Message<Object> requestmessage;
    private final VxmsShared vxmsShared;
    private final Throwable failure;
    private final Consumer<Throwable> errorMethodHandler;

    public EventbusBridgeRequest(String methodId, Message<Object> requestmessage, VxmsShared vxmsShared, Throwable failure, Consumer<Throwable> errorMethodHandler) {
        this.vxmsShared = vxmsShared;
        this.failure = failure;
        this.errorMethodHandler = errorMethodHandler;
        this.requestmessage = requestmessage;
        this.methodId = methodId;
    }

    public EventbusBridgeResponse send(String id, Object message) {
        return new EventbusBridgeResponse(this.methodId, this.requestmessage, this.vxmsShared, this.failure, this.errorMethodHandler, id, message, null);
    }

    public EventbusBridgeResponse send(String id, Object message, DeliveryOptions requestOptions) {
        return new EventbusBridgeResponse(this.methodId, this.requestmessage, this.vxmsShared, this.failure, this.errorMethodHandler, id, message, requestOptions);
    }

    public void sendAndRespondRequest(String id, Object message) {
        this.sendAndRespondRequest(id, message, new DeliveryOptions());
    }

    public void sendAndRespondRequest(String id, Object message, DeliveryOptions requestOptions) {
        Vertx vertx = this.vxmsShared.getVertx();
        vertx.eventBus().send(id, message, requestOptions != null ? requestOptions : new DeliveryOptions(), event -> {
            if (event.failed()) {
                this.requestmessage.fail(HttpResponseStatus.SERVICE_UNAVAILABLE.code(), event.cause().getMessage());
            }
            Optional.ofNullable(event.result()).ifPresent(result -> Optional.ofNullable(result.body()).ifPresent(resp -> this.respond(resp, requestOptions)));
        });
    }

    protected void respond(Object resp, DeliveryOptions options) {
        if (resp instanceof String) {
            if (options != null) {
                this.requestmessage.reply(resp, options);
            } else {
                this.requestmessage.reply(resp);
            }
        } else if (resp instanceof byte[]) {
            if (options != null) {
                this.requestmessage.reply((Object)Buffer.buffer((byte[])((byte[])resp)), options);
            } else {
                this.requestmessage.reply((Object)Buffer.buffer((byte[])((byte[])resp)));
            }
        } else if (resp instanceof JsonObject) {
            if (options != null) {
                this.requestmessage.reply((Object)((JsonObject)JsonObject.class.cast(resp)).encode(), options);
            } else {
                this.requestmessage.reply((Object)((JsonObject)JsonObject.class.cast(resp)).encode());
            }
        } else if (resp instanceof JsonArray) {
            if (options != null) {
                this.requestmessage.reply((Object)((JsonArray)JsonArray.class.cast(resp)).encode(), options);
            } else {
                this.requestmessage.reply((Object)((JsonArray)JsonArray.class.cast(resp)).encode());
            }
        }
    }

    public EventbusBridgeBlockingRequest blocking() {
        return new EventbusBridgeBlockingRequest(this.methodId, this.requestmessage, this.vxmsShared, this.failure, this.errorMethodHandler);
    }
}

