/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vxms.event.response;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jacpfx.vxms.common.BlockingExecutionStep;
import org.jacpfx.vxms.common.ExecutionResult;
import org.jacpfx.vxms.common.ExecutionStep;
import org.jacpfx.vxms.common.VxmsShared;
import org.jacpfx.vxms.common.throwable.ThrowableErrorConsumer;
import org.jacpfx.vxms.common.throwable.ThrowableFunction;
import org.jacpfx.vxms.common.throwable.ThrowableFutureBiConsumer;
import org.jacpfx.vxms.common.throwable.ThrowableSupplier;
import org.jacpfx.vxms.event.response.blocking.ResponseBlockingExecution;
import org.jacpfx.vxms.event.response.blocking.StepExecution;

public abstract class AbstractResponse<T> {
    protected void executeStep(String methodId, VxmsShared vxmsShared, Throwable failure, Consumer<Throwable> errorMethodHandler, List<ExecutionStep> chainList, T result, ExecutionStep element, ThrowableFutureBiConsumer step, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, long timeout, long circuitBreakerTimeout, int retry) {
        org.jacpfx.vxms.event.response.basic.StepExecution.createResponse(methodId, retry, timeout, circuitBreakerTimeout, step, result, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, failure, value -> {
            int index = chainList.indexOf(element);
            int size = chainList.size();
            if (value.succeeded()) {
                if (index == size - 1 || value.handledError()) {
                    this.respond(value.getResult());
                } else {
                    ExecutionStep executionStepAndThan = (ExecutionStep)chainList.get(index + 1);
                    Optional.ofNullable(executionStepAndThan.getStep()).ifPresent(nextStep -> this.executeStep(methodId, vxmsShared, failure, errorMethodHandler, chainList, (T)value.getResult(), executionStepAndThan, (ThrowableFutureBiConsumer)nextStep, errorHandler, onFailureRespond, timeout, circuitBreakerTimeout, retry));
                }
            } else {
                this.fail(value.getCause().getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
        });
    }

    protected void getResultHandler(String methodId, VxmsShared vxmsShared, Throwable failure, Consumer<Throwable> errorMethodHandler, List<ExecutionStep> chainList, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, long timeout, long circuitBreakerTimeout, int retry, ExecutionResult<T> value) {
        if (value.succeeded()) {
            Object result = value.getResult();
            if (chainList.size() > 1 && !value.handledError()) {
                ExecutionStep executionStepAndThan = chainList.get(1);
                Optional.ofNullable(executionStepAndThan.getStep()).ifPresent(step -> this.executeStep(methodId, vxmsShared, failure, errorMethodHandler, chainList, (T)result, executionStepAndThan, (ThrowableFutureBiConsumer)step, errorHandler, onFailureRespond, timeout, circuitBreakerTimeout, retry));
            } else {
                this.respond(value.getResult());
            }
        } else {
            this.fail(value.getCause().getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        }
    }

    protected void executeBlocking(String methodId, ThrowableSupplier<T> supplier, Future<ExecutionResult<T>> blockingHandler, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Throwable failure, int retry, long timeout, long circuitBreakerTimeout, long delay) {
        ResponseBlockingExecution.createResponseBlocking(methodId, supplier, blockingHandler, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, failure, retry, timeout, circuitBreakerTimeout, delay);
    }

    protected void executeBlockingStep(String methodId, ThrowableFunction stepNext, Object result, Future<ExecutionResult<T>> handler, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Throwable failure, int retry, long timeout, long circuitBreakerTimeout, long delay) {
        StepExecution.createResponseBlocking(methodId, stepNext, result, handler, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, failure, retry, timeout, circuitBreakerTimeout, delay);
    }

    protected Handler<AsyncResult<ExecutionResult<T>>> getBlockingResultHandler(String methodId, BlockingExecutionStep step, List<BlockingExecutionStep> chainList, Consumer<Throwable> errorHandler, ThrowableFunction onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Throwable failure, int retry, long timeout, long circuitBreakerTimeout, long delay) {
        return value -> {
            if (!value.failed()) {
                ExecutionResult result = (ExecutionResult)value.result();
                if (!result.handledError()) {
                    int size;
                    int index = chainList.indexOf(step);
                    if (index == (size = chainList.size()) - 1) {
                        this.respond(result.getResult());
                    } else {
                        BlockingExecutionStep executionStepAndThan = (BlockingExecutionStep)chainList.get(index + 1);
                        Vertx vertx = vxmsShared.getVertx();
                        Object res = result.getResult();
                        vertx.executeBlocking(handler -> Optional.ofNullable(executionStepAndThan.getStep()).ifPresent(stepNext -> this.executeBlockingStep(methodId, (ThrowableFunction)stepNext, res, (Future<ExecutionResult<T>>)handler, errorHandler, (ThrowableFunction<Throwable, T>)onFailureRespond, errorMethodHandler, vxmsShared, failure, retry, timeout, circuitBreakerTimeout, delay)), false, this.getBlockingResultHandler(methodId, executionStepAndThan, chainList, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, failure, retry, timeout, circuitBreakerTimeout, delay));
                    }
                } else {
                    this.respond(result.getResult());
                }
            } else {
                this.fail(value.cause().getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
        };
    }

    protected Handler<AsyncResult<ExecutionResult<T>>> getBlockingResultHandler(int retry) {
        return value -> {
            if (!value.failed()) {
                ExecutionResult result = (ExecutionResult)value.result();
                this.respond(result.getResult());
            } else if (retry == 0) {
                this.fail(value.cause().getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
        };
    }

    protected abstract void respond(T var1);

    protected abstract void fail(String var1, int var2);
}

