/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vxms.event.response.basic;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.jacpfx.vxms.common.ExecutionResult;
import org.jacpfx.vxms.common.VxmsShared;
import org.jacpfx.vxms.common.concurrent.LocalData;
import org.jacpfx.vxms.common.throwable.ThrowableErrorConsumer;
import org.jacpfx.vxms.common.throwable.ThrowableFutureBiConsumer;

public class StepExecution {
    private static final int DEFAULT_VALUE = 0;
    private static final long DEFAULT_LONG_VALUE = 0L;
    private static final int DEFAULT_LOCK_TIMEOUT = 2000;
    private static final long LOCK_VALUE = -1L;

    public static <T, V> void createResponse(String methodId, int retry, long timeout, long circuitBreakerTimeout, ThrowableFutureBiConsumer<T, V> step, T inputValue, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, V> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Throwable failure, Consumer<ExecutionResult<V>> resultConsumer) {
        if (circuitBreakerTimeout > 0L) {
            StepExecution.executeStateful(methodId, retry, timeout, circuitBreakerTimeout, step, inputValue, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, failure, resultConsumer);
        } else {
            StepExecution.executeStateless(methodId, retry, timeout, circuitBreakerTimeout, step, inputValue, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer);
        }
    }

    private static <T, V> void executeStateless(String _methodId, int _retry, long _timeout, long _release, ThrowableFutureBiConsumer<T, V> step, T inputValue, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, V> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Consumer<ExecutionResult<V>> resultConsumer) {
        Future operationResult = Future.future();
        operationResult.setHandler(event -> {
            if (event.failed()) {
                int retryTemp = _retry - 1;
                StepExecution.retryOrFail(_methodId, _timeout, _release, step, inputValue, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer, event, retryTemp);
            } else {
                resultConsumer.accept(new ExecutionResult(event.result(), true, null));
            }
        });
        if (_timeout > 0L) {
            StepExecution.addTimeoutHandler(_timeout, vxmsShared, (Handler<Long>)((Handler)l -> {
                if (!operationResult.isComplete()) {
                    operationResult.fail((Throwable)new TimeoutException("operation timeout"));
                }
            }));
        }
        StepExecution.executeAndCompleate(step, inputValue, operationResult);
    }

    private static <T, V> void executeAndCompleate(ThrowableFutureBiConsumer<T, V> step, T inputValue, Future<V> operationResult) {
        try {
            step.accept(inputValue, operationResult);
        }
        catch (Throwable throwable) {
            operationResult.fail(throwable);
        }
    }

    private static <T, V> void retryOrFail(String _methodId, long _timeout, long _release, ThrowableFutureBiConsumer<T, V> step, T inputValue, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, V> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Consumer<ExecutionResult<V>> resultConsumer, AsyncResult<V> event, int retryTemp) {
        if (retryTemp < 0) {
            StepExecution.errorHandling(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, event);
        } else {
            StepExecution.retry(_methodId, retryTemp, _timeout, _release, step, inputValue, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer, event);
        }
    }

    private static <T, V> void executeStateful(String _methodId, int _retry, long _timeout, long _circuitBreakerTimeout, ThrowableFutureBiConsumer<T, V> step, T inputValue, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, V> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Throwable t, Consumer<ExecutionResult<V>> resultConsumer) {
        Future operationResult = Future.future();
        operationResult.setHandler(event -> {
            if (event.failed()) {
                StepExecution.statefulErrorHandling(_methodId, _retry, _timeout, _circuitBreakerTimeout, step, inputValue, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer, event);
            } else {
                resultConsumer.accept(new ExecutionResult(event.result(), true, null));
            }
        });
        StepExecution.executeLocked((lock, counter) -> counter.get(counterHandler -> {
            long currentVal = (Long)counterHandler.result();
            if (currentVal == 0L) {
                StepExecution.executeInitialState(_retry, _timeout, step, inputValue, vxmsShared, operationResult, lock, counter);
            } else if (currentVal > 0L) {
                StepExecution.executeDefaultState(_timeout, step, inputValue, vxmsShared, operationResult, lock);
            } else {
                StepExecution.releaseLockAndHandleError(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, lock, Optional.ofNullable(t).orElse(Future.failedFuture((String)"circuit open").cause()));
            }
        }), _methodId, vxmsShared, errorHandler, onFailureRespond, errorMethodHandler, resultConsumer);
    }

    private static <T> void releaseLockAndHandleError(Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Consumer<ExecutionResult<T>> resultConsumer, Lock lock, Throwable cause) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        StepExecution.errorHandling(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, Future.failedFuture((Throwable)cause));
    }

    private static <T, V> void executeDefaultState(long _timeout, ThrowableFutureBiConsumer<T, V> step, T inputValue, VxmsShared vxmsShared, Future<V> operationResult, Lock lock) {
        lock.release();
        if (_timeout > 0L) {
            StepExecution.addTimeoutHandler(_timeout, vxmsShared, (Handler<Long>)((Handler)l -> {
                if (!operationResult.isComplete()) {
                    operationResult.fail((Throwable)new TimeoutException("operation timeout"));
                }
            }));
        }
        StepExecution.executeAndCompleate(step, inputValue, operationResult);
    }

    private static <T, V> void executeInitialState(int _retry, long _timeout, ThrowableFutureBiConsumer<T, V> step, T inputValue, VxmsShared vxmsShared, Future<V> operationResult, Lock lock, Counter counter) {
        long initialRetryCounterValue = _retry + 1;
        counter.addAndGet(initialRetryCounterValue, rHandler -> StepExecution.executeDefaultState(_timeout, step, inputValue, vxmsShared, operationResult, lock));
    }

    private static <T, V> void statefulErrorHandling(String _methodId, int _retry, long _timeout, long _circuitBreakerTimeout, ThrowableFutureBiConsumer<T, V> step, T inputValue, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, V> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Consumer<ExecutionResult<V>> resultConsumer, AsyncResult<V> event) {
        StepExecution.executeLocked((lock, counter) -> counter.decrementAndGet(valHandler -> {
            if (valHandler.succeeded()) {
                StepExecution.handleStatefulError(_methodId, _retry, _timeout, _circuitBreakerTimeout, step, inputValue, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer, event, lock, counter, (AsyncResult<Long>)valHandler);
            } else {
                StepExecution.releaseLockAndHandleError(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, lock, valHandler.cause());
            }
        }), _methodId, vxmsShared, errorHandler, onFailureRespond, errorMethodHandler, resultConsumer);
    }

    private static <T, V> void handleStatefulError(String _methodId, int _retry, long _timeout, long _circuitBreakerTimeout, ThrowableFutureBiConsumer<T, V> step, T inputValue, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, V> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Consumer<ExecutionResult<V>> resultConsumer, AsyncResult<V> event, Lock lock, Counter counter, AsyncResult<Long> valHandler) {
        long count = (Long)valHandler.result();
        if (count <= 0L) {
            StepExecution.setCircuitBreakerReleaseTimer(_retry, _circuitBreakerTimeout, vxmsShared, counter);
            StepExecution.openCircuitBreakerAndHandleError(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, event, lock, counter);
        } else {
            lock.release();
            StepExecution.retry(_methodId, _retry, _timeout, _circuitBreakerTimeout, step, inputValue, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, resultConsumer, event);
        }
    }

    private static <T> void openCircuitBreakerAndHandleError(Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Consumer<ExecutionResult<T>> resultConsumer, AsyncResult<T> event, Lock lock, Counter counter) {
        counter.addAndGet(-1L, val -> {
            lock.release();
            StepExecution.errorHandling(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, Future.failedFuture((Throwable)event.cause()));
        });
    }

    private static void setCircuitBreakerReleaseTimer(int _retry, long _release, VxmsShared vxmsShared, Counter counter) {
        long initialRetryCounterValue = _retry + 1;
        Vertx vertx = vxmsShared.getVertx();
        vertx.setTimer(_release, timer -> counter.addAndGet(initialRetryCounterValue, val -> {}));
    }

    private static void addTimeoutHandler(long _timeout, VxmsShared vxmsShared, Handler<Long> longHandler) {
        Vertx vertx = vxmsShared.getVertx();
        vertx.setTimer(_timeout, longHandler);
    }

    private static <T> void errorHandling(Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Consumer<ExecutionResult<T>> resultConsumer, AsyncResult<T> event) {
        try {
            Future errorResult = Future.future();
            errorResult.setHandler(resultHandler -> {
                if (resultHandler.succeeded()) {
                    resultConsumer.accept(new ExecutionResult(resultHandler.result(), true, true, null));
                } else {
                    StepExecution.handleExecutionError(null, errorHandler, null, errorMethodHandler, resultHandler.cause());
                }
            });
            StepExecution.handleExecutionError(errorResult, errorHandler, onFailureRespond, errorMethodHandler, event.cause());
        }
        catch (Exception e) {
            resultConsumer.accept(new ExecutionResult(null, false, (Throwable)e));
        }
    }

    private static <T, V> void retry(String _methodId, int retryTemp, long _timeout, long _release, ThrowableFutureBiConsumer<T, V> step, T inputValue, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, V> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Consumer<ExecutionResult<V>> resultConsumer, AsyncResult<V> event) {
        StepExecution.handleError(errorHandler, event.cause());
        StepExecution.createResponse(_methodId, retryTemp, _timeout, _release, step, inputValue, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, null, resultConsumer);
    }

    private static <T> void handleExecutionError(Future<T> errorResult, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Throwable e) {
        StepExecution.handleError(errorHandler, e);
        try {
            if (onFailureRespond != null) {
                onFailureRespond.accept((Object)e, errorResult);
            } else {
                errorMethodHandler.accept(e);
            }
        }
        catch (Throwable throwable) {
            errorResult.fail(throwable);
        }
    }

    private static void handleError(Consumer<Throwable> errorHandler, Throwable e) {
        if (errorHandler != null) {
            errorHandler.accept(e);
        }
    }

    private static <T> void executeLocked(LockedConsumer consumer, String _methodId, VxmsShared vxmsShared, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Consumer<ExecutionResult<T>> resultConsumer) {
        LocalData sharedData = vxmsShared.getLocalData();
        sharedData.getLockWithTimeout(_methodId, 2000L, lockHandler -> {
            Lock lock = (Lock)lockHandler.result();
            if (lockHandler.succeeded()) {
                sharedData.getCounter(_methodId, resultHandler -> {
                    if (resultHandler.succeeded()) {
                        consumer.execute(lock, (Counter)resultHandler.result());
                    } else {
                        StepExecution.releaseLockAndHandleError(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, lock, resultHandler.cause());
                    }
                });
            } else {
                StepExecution.releaseLockAndHandleError(errorHandler, onFailureRespond, errorMethodHandler, resultConsumer, lock, lockHandler.cause());
            }
        });
    }

    private static interface LockedConsumer {
        public void execute(Lock var1, Counter var2);
    }
}

