/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vxms.event.response.basic;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jacpfx.vxms.common.ExecutionStep;
import org.jacpfx.vxms.common.VxmsShared;
import org.jacpfx.vxms.common.throwable.ThrowableErrorConsumer;
import org.jacpfx.vxms.common.throwable.ThrowableFutureConsumer;
import org.jacpfx.vxms.event.interfaces.basic.ExecuteEventbusStringCall;
import org.jacpfx.vxms.event.response.AbstractResponse;
import org.jacpfx.vxms.event.response.basic.ResponseExecution;

public class ExecuteEventbusString
extends AbstractResponse<String> {
    protected final String methodId;
    protected final VxmsShared vxmsShared;
    protected final Throwable failure;
    protected final Consumer<Throwable> errorMethodHandler;
    protected final Message<Object> message;
    protected final List<ExecutionStep> chain;
    protected final ThrowableFutureConsumer<String> stringConsumer;
    protected final Consumer<Throwable> errorHandler;
    protected final ThrowableErrorConsumer<Throwable, String> onFailureRespond;
    protected final ExecuteEventbusStringCall excecuteEventBusAndReply;
    protected final DeliveryOptions deliveryOptions;
    protected final int retryCount;
    protected final long timeout;
    protected final long circuitBreakerTimeout;

    public ExecuteEventbusString(String methodId, VxmsShared vxmsShared, Throwable failure, Consumer<Throwable> errorMethodHandler, Message<Object> message, List<ExecutionStep> chain, ThrowableFutureConsumer<String> stringConsumer, ExecuteEventbusStringCall excecuteEventBusAndReply, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, String> onFailureRespond, DeliveryOptions deliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout) {
        this.methodId = methodId;
        this.vxmsShared = vxmsShared;
        this.failure = failure;
        this.errorMethodHandler = errorMethodHandler;
        this.message = message;
        this.chain = chain;
        this.stringConsumer = stringConsumer;
        this.excecuteEventBusAndReply = excecuteEventBusAndReply;
        this.errorHandler = errorHandler;
        this.onFailureRespond = onFailureRespond;
        this.deliveryOptions = deliveryOptions;
        this.retryCount = retryCount;
        this.timeout = timeout;
        this.circuitBreakerTimeout = circuitBreakerTimeout;
    }

    public void execute(DeliveryOptions deliveryOptions) {
        Objects.requireNonNull(deliveryOptions);
        new ExecuteEventbusString(this.methodId, this.vxmsShared, this.failure, this.errorMethodHandler, this.message, this.chain, this.stringConsumer, this.excecuteEventBusAndReply, this.errorHandler, this.onFailureRespond, deliveryOptions, this.retryCount, this.timeout, this.circuitBreakerTimeout).execute();
    }

    public void execute() {
        Vertx vertx = this.vxmsShared.getVertx();
        vertx.runOnContext(action -> {
            Optional.ofNullable(this.excecuteEventBusAndReply).ifPresent(evFunction -> {
                try {
                    evFunction.execute(this.methodId, this.vxmsShared, this.errorMethodHandler, this.message, this.errorHandler, this.onFailureRespond, this.deliveryOptions, this.retryCount, this.timeout, this.circuitBreakerTimeout);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            Optional.ofNullable(this.stringConsumer).ifPresent(userOperation -> ResponseExecution.createResponse(this.methodId, this.retryCount, this.timeout, this.circuitBreakerTimeout, userOperation, this.errorHandler, this.onFailureRespond, this.errorMethodHandler, this.vxmsShared, this.failure, value -> {
                if (value.succeeded()) {
                    this.respond((String)value.getResult());
                } else {
                    this.fail(value.getCause().getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
                }
            }));
            Optional.ofNullable(this.chain).ifPresent(chainList -> {
                if (!chainList.isEmpty()) {
                    ExecutionStep executionStep = (ExecutionStep)chainList.get(0);
                    Optional.ofNullable(executionStep.getChainconsumer()).ifPresent(initialConsumer -> {
                        int retry = this.retryCount;
                        ResponseExecution.createResponse(this.methodId, retry, this.timeout, this.circuitBreakerTimeout, initialConsumer, this.errorHandler, this.onFailureRespond, this.errorMethodHandler, this.vxmsShared, this.failure, value -> this.getResultHandler(this.methodId, this.vxmsShared, this.failure, this.errorMethodHandler, (List<ExecutionStep>)chainList, this.errorHandler, this.onFailureRespond, this.timeout, this.circuitBreakerTimeout, retry, value));
                    });
                }
            });
        });
    }

    @Override
    protected void respond(String result) {
        if (result != null) {
            if (this.deliveryOptions != null) {
                this.message.reply((Object)result, this.deliveryOptions);
            } else {
                this.message.reply((Object)result);
            }
        }
    }

    @Override
    protected void fail(String result, int statuscode) {
        if (result != null) {
            this.message.fail(statuscode, result);
        }
    }
}

