/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vxms.event.response;

import io.vertx.core.eventbus.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jacpfx.vxms.common.ExecutionStep;
import org.jacpfx.vxms.common.VxmsShared;
import org.jacpfx.vxms.common.encoder.Encoder;
import org.jacpfx.vxms.common.throwable.ThrowableFutureConsumer;
import org.jacpfx.vxms.event.response.EventbusResponseBlocking;
import org.jacpfx.vxms.event.response.basic.ExecuteEventChainResponse;
import org.jacpfx.vxms.event.response.basic.ExecuteEventbusByteResponse;
import org.jacpfx.vxms.event.response.basic.ExecuteEventbusObjectResponse;
import org.jacpfx.vxms.event.response.basic.ExecuteEventbusStringResponse;

public class EventbusResponse {
    private final String methodId;
    private final VxmsShared vxmsShared;
    private final Throwable failure;
    private final Consumer<Throwable> errorMethodHandler;
    private final Message<Object> message;

    public EventbusResponse(String methodId, VxmsShared vxmsShared, Throwable failure, Consumer<Throwable> errorMethodHandler, Message<Object> message) {
        this.methodId = methodId;
        this.vxmsShared = vxmsShared;
        this.failure = failure;
        this.errorMethodHandler = errorMethodHandler;
        this.message = message;
    }

    public EventbusResponseBlocking blocking() {
        return new EventbusResponseBlocking(this.methodId, this.message, this.vxmsShared, this.failure, this.errorMethodHandler);
    }

    public <T> ExecuteEventChainResponse<T> supply(ThrowableFutureConsumer<T> chainconsumer) {
        ArrayList<ExecutionStep> chain = new ArrayList<ExecutionStep>();
        chain.add(new ExecutionStep(chainconsumer));
        return new ExecuteEventChainResponse(this.methodId, this.vxmsShared, this.failure, this.errorMethodHandler, this.message, chain);
    }

    public ExecuteEventbusByteResponse byteResponse(ThrowableFutureConsumer<byte[]> byteConsumer) {
        return new ExecuteEventbusByteResponse(this.methodId, this.vxmsShared, this.failure, this.errorMethodHandler, this.message, null, byteConsumer);
    }

    public ExecuteEventbusStringResponse stringResponse(ThrowableFutureConsumer<String> stringConsumer) {
        return new ExecuteEventbusStringResponse(this.methodId, this.vxmsShared, this.failure, this.errorMethodHandler, this.message, null, stringConsumer);
    }

    public ExecuteEventbusObjectResponse objectResponse(ThrowableFutureConsumer<Serializable> objectConsumer, Encoder encoder) {
        return new ExecuteEventbusObjectResponse(this.methodId, this.vxmsShared, this.failure, this.errorMethodHandler, this.message, null, objectConsumer, encoder);
    }
}

