/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vxms.event.response.basic;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jacpfx.vxms.common.ExecutionStep;
import org.jacpfx.vxms.common.VxmsShared;
import org.jacpfx.vxms.common.encoder.Encoder;
import org.jacpfx.vxms.common.throwable.ThrowableErrorConsumer;
import org.jacpfx.vxms.common.throwable.ThrowableFutureConsumer;
import org.jacpfx.vxms.event.interfaces.basic.ExecuteEventbusObjectCall;
import org.jacpfx.vxms.event.response.AbstractResponse;
import org.jacpfx.vxms.event.response.basic.ResponseExecution;

public class ExecuteEventbusObject
extends AbstractResponse<Serializable> {
    protected final String methodId;
    protected final VxmsShared vxmsShared;
    protected final Throwable failure;
    protected final Message<Object> message;
    protected final List<ExecutionStep> chain;
    protected final Consumer<Throwable> errorHandler;
    protected final Consumer<Throwable> errorMethodHandler;
    protected final ThrowableFutureConsumer<Serializable> objectConsumer;
    protected final ThrowableErrorConsumer<Throwable, Serializable> onFailureRespond;
    protected final ExecuteEventbusObjectCall excecuteEventBusAndReply;
    protected final Encoder encoder;
    protected final DeliveryOptions deliveryOptions;
    protected final int retryCount;
    protected final long timeout;
    protected final long circuitBreakerTimeout;

    public ExecuteEventbusObject(String methodId, VxmsShared vxmsShared, Throwable failure, Consumer<Throwable> errorMethodHandler, Message<Object> message, List<ExecutionStep> chain, ThrowableFutureConsumer<Serializable> objectConsumer, ExecuteEventbusObjectCall excecuteEventBusAndReply, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, Serializable> onFailureRespond, DeliveryOptions deliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout) {
        this.methodId = methodId;
        this.vxmsShared = vxmsShared;
        this.failure = failure;
        this.errorMethodHandler = errorMethodHandler;
        this.message = message;
        this.chain = chain;
        this.objectConsumer = objectConsumer;
        this.encoder = encoder;
        this.deliveryOptions = deliveryOptions;
        this.errorHandler = errorHandler;
        this.onFailureRespond = onFailureRespond;
        this.retryCount = retryCount;
        this.excecuteEventBusAndReply = excecuteEventBusAndReply;
        this.timeout = timeout;
        this.circuitBreakerTimeout = circuitBreakerTimeout;
    }

    public void execute(DeliveryOptions deliveryOptions) {
        Objects.requireNonNull(deliveryOptions);
        new ExecuteEventbusObject(this.methodId, this.vxmsShared, this.failure, this.errorMethodHandler, this.message, this.chain, this.objectConsumer, this.excecuteEventBusAndReply, this.encoder, this.errorHandler, this.onFailureRespond, deliveryOptions, this.retryCount, this.timeout, this.circuitBreakerTimeout).execute();
    }

    public void execute() {
        Vertx vertx = this.vxmsShared.getVertx();
        vertx.runOnContext(action -> {
            Optional.ofNullable(this.excecuteEventBusAndReply).ifPresent(evFunction -> {
                try {
                    evFunction.execute(this.methodId, this.vxmsShared, this.errorMethodHandler, this.message, this.encoder, this.errorHandler, this.onFailureRespond, this.deliveryOptions, this.retryCount, this.timeout, this.circuitBreakerTimeout);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            Optional.ofNullable(this.objectConsumer).ifPresent(userOperation -> ResponseExecution.createResponse(this.methodId, this.retryCount, this.timeout, this.circuitBreakerTimeout, userOperation, this.errorHandler, this.onFailureRespond, this.errorMethodHandler, this.vxmsShared, this.failure, value -> {
                if (value.succeeded()) {
                    this.respond((Serializable)value.getResult());
                } else {
                    this.fail(value.getCause().getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
                }
            }));
            Optional.ofNullable(this.chain).ifPresent(chainList -> {
                if (!chainList.isEmpty()) {
                    ExecutionStep executionStep = (ExecutionStep)chainList.get(0);
                    Optional.ofNullable(executionStep.getChainconsumer()).ifPresent(initialConsumer -> {
                        int retry = this.retryCount;
                        ResponseExecution.createResponse(this.methodId, retry, this.timeout, this.circuitBreakerTimeout, initialConsumer, this.errorHandler, this.onFailureRespond, this.errorMethodHandler, this.vxmsShared, this.failure, value -> this.getResultHandler(this.methodId, this.vxmsShared, this.failure, this.errorMethodHandler, (List<ExecutionStep>)chainList, this.errorHandler, this.onFailureRespond, this.timeout, this.circuitBreakerTimeout, retry, value));
                    });
                }
            });
        });
    }

    @Override
    protected void fail(String result, int statuscode) {
        if (result != null) {
            this.message.fail(statuscode, result);
        }
    }

    @Override
    protected void respond(Serializable result) {
        if (result != null) {
            ResponseExecution.encode(result, this.encoder).ifPresent(value -> {
                if (this.deliveryOptions != null) {
                    this.message.reply(value, this.deliveryOptions);
                } else {
                    this.message.reply(value);
                }
            });
        }
    }
}

