/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vxms.event.response.blocking;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.jacpfx.vxms.common.ExecutionResult;
import org.jacpfx.vxms.common.VxmsShared;
import org.jacpfx.vxms.common.concurrent.LocalData;
import org.jacpfx.vxms.common.throwable.ThrowableFunction;
import org.jacpfx.vxms.event.response.basic.ResponseExecution;

public class StepExecution {
    private static final int DEFAULT_VALUE = 0;
    private static final long DEFAULT_LONG_VALUE = 0L;
    private static final int DEFAULT_LOCK_TIMEOUT = 2000;
    private static final int STOP_CONDITION = -1;
    private static final long LOCK_VALUE = -1L;

    public static <T, V> void createResponseBlocking(String methodId, ThrowableFunction<T, V> step, T value, Future<ExecutionResult<V>> resultHandler, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, V> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, Throwable failure, int retry, long timeout, long circuitBreakerTimeout, long delay) {
        if (circuitBreakerTimeout > 0L) {
            StepExecution.executeLocked((lock, counter) -> counter.get(counterHandler -> {
                long currentVal = (Long)counterHandler.result();
                if (currentVal == 0L) {
                    StepExecution.executeInitialState(methodId, step, value, resultHandler, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, failure, retry, timeout, circuitBreakerTimeout, delay, lock, counter);
                } else if (currentVal > 0L) {
                    StepExecution.executeDefault(methodId, step, value, resultHandler, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, failure, retry, timeout, circuitBreakerTimeout, delay, lock);
                } else {
                    StepExecution.executeErrorState(resultHandler, errorHandler, onFailureRespond, errorMethodHandler, failure, lock);
                }
            }), methodId, vxmsShared, resultHandler, errorHandler, onFailureRespond, errorMethodHandler, null);
        } else {
            StepExecution.executeStateless(step, value, resultHandler, errorHandler, onFailureRespond, errorMethodHandler, vxmsShared, retry, timeout, delay);
        }
    }

    private static <T> void executeErrorState(Future<ExecutionResult<T>> _blockingHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Throwable failure, Lock lock) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        StepExecution.handleErrorExecution(_blockingHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, Optional.ofNullable(failure).orElse(Future.failedFuture((String)"circuit open").cause()));
    }

    private static <T, V> void executeDefault(String _methodId, ThrowableFunction<T, V> step, T value, Future<ExecutionResult<V>> _resultHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, V> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, VxmsShared vxmsShared, Throwable _failure, int _retry, long _timeout, long _circuitBreakerTimeout, long _delay, Lock lock) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        Vertx vertx = vxmsShared.getVertx();
        vertx.executeBlocking(bhandler -> {
            try {
                StepExecution.executeDefaultState(step, value, _resultHandler, vxmsShared, _timeout);
                bhandler.complete();
            }
            catch (Throwable e) {
                StepExecution.executeLocked((lck, counter) -> counter.decrementAndGet(valHandler -> {
                    if (valHandler.succeeded()) {
                        StepExecution.handleStatefulError(_methodId, step, value, _resultHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, vxmsShared, _failure, _retry, _timeout, _circuitBreakerTimeout, _delay, e, lck, counter, (AsyncResult<Long>)valHandler);
                        bhandler.complete();
                    } else {
                        StepExecution.releaseLockAndHandleError(_resultHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, valHandler.cause(), lck);
                        bhandler.complete();
                    }
                }), _methodId, vxmsShared, _resultHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, bhandler);
            }
        }, false, res -> {});
    }

    private static <T, V> void executeInitialState(String _methodId, ThrowableFunction<T, V> step, T value, Future<ExecutionResult<V>> _resultHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, V> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, VxmsShared vxmsShared, Throwable _t, int _retry, long _timeout, long _circuitBreakerTimeout, long _delay, Lock lock, Counter counter) {
        long initialRetryCounterValue = _retry + 1;
        counter.addAndGet(initialRetryCounterValue, rHandler -> StepExecution.executeDefault(_methodId, step, value, _resultHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, vxmsShared, _t, _retry, _timeout, _circuitBreakerTimeout, _delay, lock));
    }

    private static <T> void releaseLockAndHandleError(Future<ExecutionResult<T>> _resultHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Throwable cause, Lock lock) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        StepExecution.handleErrorExecution(_resultHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, cause);
    }

    private static <T> void handleErrorExecution(Future<ExecutionResult<T>> _resultHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Throwable cause) {
        T result = StepExecution.handleError(_errorHandler, _onFailureRespond, _errorMethodHandler, cause);
        if (!_resultHandler.isComplete()) {
            _resultHandler.complete((Object)new ExecutionResult(result, true, true, null));
        }
    }

    private static <T, V> void handleStatefulError(String _methodId, ThrowableFunction<T, V> step, T value, Future<ExecutionResult<V>> _resultHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, V> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, VxmsShared vxmsShared, Throwable _t, int _retry, long _timeout, long _circuitBreakerTimeout, long _delay, Throwable e, Lock lck, Counter counter, AsyncResult<Long> valHandler) {
        long count = (Long)valHandler.result();
        if (count <= 0L) {
            StepExecution.setCircuitBreakerReleaseTimer(vxmsShared, _retry, _circuitBreakerTimeout, counter);
            StepExecution.openCircuitBreakerAndHandleError(_resultHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, vxmsShared, e, lck, counter);
        } else {
            lck.release();
            ResponseExecution.handleError(_errorHandler, e);
            StepExecution.handleDelay(_delay);
            StepExecution.createResponseBlocking(_methodId, step, value, _resultHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, vxmsShared, _t, _retry, _timeout, _circuitBreakerTimeout, _delay);
        }
    }

    private static <T> void openCircuitBreakerAndHandleError(Future<ExecutionResult<T>> _resultHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, VxmsShared vxmsShared, Throwable e, Lock lck, Counter counter) {
        counter.addAndGet(-1L, val -> {
            lck.release();
            Vertx vertx = vxmsShared.getVertx();
            vertx.executeBlocking(bhandler -> {
                Object result = StepExecution.handleError(_errorHandler, _onFailureRespond, _errorMethodHandler, e);
                if (!_resultHandler.isComplete()) {
                    _resultHandler.complete((Object)new ExecutionResult(result, true, true, null));
                }
            }, false, res -> {});
        });
    }

    private static void setCircuitBreakerReleaseTimer(VxmsShared vxmsShared, int _retry, long _circuitBreakerTimeout, Counter counter) {
        long initialRetryCounterValue = _retry + 1;
        Vertx vertx = vxmsShared.getVertx();
        vertx.setTimer(_circuitBreakerTimeout, timer -> counter.addAndGet(initialRetryCounterValue, val -> {}));
    }

    private static <T, V> void executeDefaultState(ThrowableFunction<T, V> step, T value, Future<ExecutionResult<V>> _resultHandler, VxmsShared vxmsShared, long _timeout) throws Throwable {
        Object result = _timeout > 0L ? StepExecution.executeWithTimeout(step, value, vxmsShared, _timeout) : step.apply(value);
        if (!_resultHandler.isComplete()) {
            _resultHandler.complete((Object)new ExecutionResult(result, true, false, null));
        }
    }

    private static <T, V> V executeWithTimeout(ThrowableFunction<T, V> step, T value, VxmsShared vxmsShared, long _timeout) throws Throwable {
        Object result;
        CompletableFuture timeoutFuture = new CompletableFuture();
        Vertx vertx = vxmsShared.getVertx();
        vertx.executeBlocking(innerHandler -> {
            try {
                timeoutFuture.complete(step.apply(value));
            }
            catch (Throwable throwable) {
                timeoutFuture.obtrudeException(throwable);
            }
        }, false, val -> {});
        try {
            result = timeoutFuture.get(_timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeout) {
            throw new TimeoutException("operation _timeout");
        }
        return (V)result;
    }

    private static <T, V> void executeStateless(ThrowableFunction<T, V> step, T value, Future<ExecutionResult<V>> _blockingHandler, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, V> onFailureRespond, Consumer<Throwable> errorMethodHandler, VxmsShared vxmsShared, int _retry, long timeout, long delay) {
        Object result = null;
        boolean errorHandling = false;
        while (_retry >= 0) {
            errorHandling = false;
            try {
                if (timeout > 0L) {
                    result = StepExecution.executeWithTimeout(step, value, vxmsShared, timeout);
                    _retry = -1;
                    continue;
                }
                result = step.apply(value);
                _retry = -1;
            }
            catch (Throwable e) {
                if (--_retry < 0) {
                    try {
                        result = StepExecution.handleError(errorHandler, onFailureRespond, errorMethodHandler, e);
                        errorHandling = true;
                    }
                    catch (Exception ee) {
                        _blockingHandler.fail((Throwable)ee);
                    }
                    continue;
                }
                ResponseExecution.handleError(errorHandler, e);
                StepExecution.handleDelay(delay);
            }
        }
        if (!_blockingHandler.isComplete()) {
            _blockingHandler.complete((Object)new ExecutionResult(result, true, errorHandling, null));
        }
    }

    private static void handleDelay(long delay) {
        try {
            if (delay > 0L) {
                Thread.sleep(delay);
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    private static <T> T handleError(Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, T> onFailureRespond, Consumer<Throwable> errorMethodHandler, Throwable e) {
        Object result = null;
        try {
            if (errorHandler != null) {
                errorHandler.accept(e);
            }
            if (onFailureRespond != null) {
                result = onFailureRespond.apply((Object)e);
            }
            if (errorHandler == null && onFailureRespond == null) {
                errorMethodHandler.accept(e);
                return null;
            }
        }
        catch (Throwable throwable) {
            errorMethodHandler.accept(throwable);
        }
        return (T)result;
    }

    private static <T, U> void executeLocked(LockedConsumer consumer, String _methodId, VxmsShared vxmsShared, Future<ExecutionResult<T>> _resultHandler, Consumer<Throwable> _errorHandler, ThrowableFunction<Throwable, T> _onFailureRespond, Consumer<Throwable> _errorMethodHandler, Future<U> blockingCodeHandler) {
        LocalData sharedData = vxmsShared.getLocalData();
        sharedData.getLockWithTimeout(_methodId, 2000L, lockHandler -> {
            Lock lock = (Lock)lockHandler.result();
            if (lockHandler.succeeded()) {
                sharedData.getCounter(_methodId, resultHandler -> {
                    if (resultHandler.succeeded()) {
                        consumer.execute(lock, (Counter)resultHandler.result());
                    } else {
                        StepExecution.releaseLockAndHandleError(_resultHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, resultHandler.cause(), lock);
                        Optional.ofNullable(blockingCodeHandler).ifPresent(Future::complete);
                    }
                });
            } else {
                StepExecution.handleErrorExecution(_resultHandler, _errorHandler, _onFailureRespond, _errorMethodHandler, lockHandler.cause());
                Optional.ofNullable(blockingCodeHandler).ifPresent(Future::complete);
            }
        });
    }

    private static interface LockedConsumer {
        public void execute(Lock var1, Counter var2);
    }
}

