/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.tools.xml.validator;

import com.levigo.tools.xml.validator.XmlParserProperties;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VERIFY)
public class ValidateMojo
extends AbstractMojo {
    private final XmlParserProperties xmlParserProperties = new XmlParserProperties();
    @Parameter(required=true)
    private File schema;
    @Parameter(required=true)
    private File source;
    @Parameter(property="skipXMLValidation")
    private boolean skip = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping XML Validation.");
            return;
        }
        this.xmlParserProperties.set();
        try {
            this.validate();
        }
        catch (SAXException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            this.xmlParserProperties.restore();
        }
    }

    private void validate() throws IOException, SAXException, MojoFailureException {
        InputSource xmlSource;
        ValidationDriver validationDriver = this.createValidationDriver();
        boolean isValid = validationDriver.validate(xmlSource = ValidationDriver.fileInputSource((File)this.source));
        if (!isValid) {
            throw new MojoFailureException("File is NOT VALID. File: " + this.source);
        }
        this.getLog().info((CharSequence)"XML file validates. No problems detected.");
    }

    private ValidationDriver createValidationDriver() throws IOException, SAXException {
        AutoSchemaReader schemaReader = new AutoSchemaReader();
        ValidationDriver validationDriver = new ValidationDriver((SchemaReader)schemaReader);
        InputSource schemaSource = ValidationDriver.fileInputSource((File)this.schema);
        validationDriver.loadSchema(schemaSource);
        return validationDriver;
    }
}

