/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.maven.plugins.fmpp;

import fmpp.ProcessingException;
import fmpp.ProgressListener;
import fmpp.progresslisteners.ConsoleProgressListener;
import fmpp.setting.SettingException;
import fmpp.setting.Settings;
import fmpp.util.MiscUtil;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class FmppMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="true", property="compileSourceRoot")
    private boolean compileSourceRoot;
    @Parameter(defaultValue="false", property="testCompileSourceRoot")
    private boolean testCompileSourceRoot;
    @Parameter(defaultValue="src/main/resources/fmpp/config.fmpp", required=true, property="cfgFile")
    private File cfgFile;
    @Parameter(defaultValue="src/main/resources/fmpp/templates/", required=true, property="templateDirectory")
    private File templateDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/fmpp/", required=true, property="outputDirectory")
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkParameters();
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        this.getLog().info((CharSequence)"Beginning FMPP Processing... ");
        try {
            Settings settings = new Settings(new File("."));
            settings.set("sourceRoot", (Object)this.templateDirectory.getAbsolutePath());
            settings.set("outputRoot", (Object)this.outputDirectory.getAbsolutePath());
            settings.load(this.cfgFile);
            settings.addProgressListener((ProgressListener)new ConsoleProgressListener());
            settings.execute();
        }
        catch (SettingException e) {
            this.handleError((Exception)((Object)e));
        }
        catch (ProcessingException e) {
            this.handleError((Exception)((Object)e));
        }
        this.getLog().info((CharSequence)"Successfully completed FMPP Processing... ");
        if (this.compileSourceRoot) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        if (this.testCompileSourceRoot) {
            this.project.addTestCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
    }

    private void handleError(Exception e) throws MojoFailureException {
        this.getLog().error((CharSequence)MiscUtil.causeMessages((Throwable)e));
        throw new MojoFailureException(MiscUtil.causeMessages((Throwable)e), (Throwable)e);
    }

    private void checkParameters() throws MojoExecutionException {
        if (this.project == null) {
            throw new MojoExecutionException("This plugin can only be used as part of a Maven project.");
        }
        if (this.cfgFile == null) {
            throw new MojoExecutionException("configFile is a required parameter");
        }
        if (this.templateDirectory == null) {
            throw new MojoExecutionException("templateDirectory is a required parameter");
        }
        if (this.outputDirectory == null) {
            throw new MojoExecutionException("outputDirectory is a required parameter");
        }
    }
}

