/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.kernelstats;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import org.jaitools.numeric.SampleStats;
import org.jaitools.numeric.Statistic;

public class KernelStatsOpImage
extends AreaOpImage {
    private int[] srcBandOffsets;
    private int srcPixelStride;
    private int srcScanlineStride;
    private int destWidth;
    private int destHeight;
    private int destBands;
    private int[] destBandOffsets;
    private int destPixelStride;
    private int destScanlineStride;
    private int srcBand;
    private boolean[] inKernel;
    private int kernelN;
    private int kernelW;
    private int kernelH;
    private int kernelKeyX;
    private int kernelKeyY;
    private ROI roi;
    private boolean maskSrc;
    private boolean maskDest;
    private Statistic[] stats;
    private Double[] sampleData;
    private Calculator functionTable;
    private Number nilValue;

    public KernelStatsOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, Statistic[] stats, KernelJAI kernel, int band, ROI roi, boolean maskSrc, boolean maskDest, boolean ignoreNaN, Number nilValue) {
        super(source, layout, config, true, extender, kernel.getLeftPadding(), kernel.getRightPadding(), kernel.getTopPadding(), kernel.getBottomPadding());
        this.srcBand = band;
        this.kernelW = kernel.getWidth();
        this.kernelH = kernel.getHeight();
        this.kernelKeyX = kernel.getXOrigin();
        this.kernelKeyY = kernel.getYOrigin();
        float FTOL = 1.0E-8f;
        this.inKernel = new boolean[this.kernelW * this.kernelH];
        float[] data = kernel.getKernelData();
        this.kernelN = 0;
        for (int i = 0; i < this.inKernel.length; ++i) {
            if (Math.abs(data[i]) > 1.0E-8f) {
                this.inKernel[i] = true;
                ++this.kernelN;
                continue;
            }
            this.inKernel[i] = false;
        }
        this.stats = new Statistic[stats.length];
        System.arraycopy(stats, 0, this.stats, 0, stats.length);
        this.roi = roi;
        if (roi == null) {
            this.maskDest = false;
            this.maskSrc = false;
        } else {
            Rectangle sourceBounds = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
            if (!roi.getBounds().contains(sourceBounds)) {
                throw new IllegalArgumentException("The bounds of the ROI must contain the source image");
            }
            this.maskSrc = maskSrc;
            this.maskDest = maskDest;
        }
        this.functionTable = new Calculator(ignoreNaN);
        this.nilValue = nilValue;
        this.sampleData = new Double[this.kernelN];
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAcc = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor destAcc = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        this.destWidth = destAcc.getWidth();
        this.destHeight = destAcc.getHeight();
        this.destBands = destAcc.getNumBands();
        this.destBandOffsets = destAcc.getBandOffsets();
        this.destPixelStride = destAcc.getPixelStride();
        this.destScanlineStride = destAcc.getScanlineStride();
        this.srcBandOffsets = srcAcc.getBandOffsets();
        this.srcPixelStride = srcAcc.getPixelStride();
        this.srcScanlineStride = srcAcc.getScanlineStride();
        switch (destAcc.getDataType()) {
            case 0: {
                this.calcByteData(srcAcc, destAcc);
                break;
            }
            case 2: {
                this.calcShortData(srcAcc, destAcc);
                break;
            }
            case 1: {
                this.calcUShortData(srcAcc, destAcc);
                break;
            }
            case 3: {
                this.calcIntData(srcAcc, destAcc);
                break;
            }
            case 4: {
                this.calcFloatData(srcAcc, destAcc);
                break;
            }
            case 5: {
                this.calcDoubleData(srcAcc, destAcc);
            }
        }
        if (destAcc.isDataCopy()) {
            destAcc.clampDataArrays();
            destAcc.copyDataToRaster();
        }
    }

    private void calcByteData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        byte[][] srcData = srcAcc.getByteDataArrays();
        byte[][] destData = destAcc.getByteDataArrays();
        int destY = destAcc.getY();
        int destX = destAcc.getX();
        byte[] srcBandData = srcData[this.srcBand];
        int srcScanlineOffset = this.srcBandOffsets[this.srcBand];
        int destLineDelta = 0;
        int j = 0;
        while (j < this.destHeight) {
            int srcPixelOffset = srcScanlineOffset;
            int destPixelDelta = 0;
            int i = 0;
            while (i < this.destWidth) {
                int numSamples = 0;
                if (!this.maskDest || this.roi.contains(destX, destY)) {
                    int srcY = destY - this.kernelKeyY;
                    int kernelVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < this.kernelH) {
                        int srcX = destX - this.kernelKeyX;
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < this.kernelW) {
                            if ((!this.maskSrc || this.roi.contains(srcX, srcY)) && this.inKernel[kernelVerticalOffset + v]) {
                                this.sampleData[numSamples++] = srcBandData[imageOffset] & 0xFF;
                            }
                            imageOffset += this.srcPixelStride;
                            ++v;
                            ++srcX;
                        }
                        kernelVerticalOffset += this.kernelW;
                        imageVerticalOffset += this.srcScanlineStride;
                        ++u;
                        ++srcY;
                    }
                }
                for (int band = 0; band < this.destBands; ++band) {
                    double statValue;
                    byte[] destBandData = destData[band];
                    int dstPixelOffset = this.destBandOffsets[band] + destPixelDelta + destLineDelta;
                    int val = this.nilValue.byteValue();
                    if (numSamples > 0 && !Double.isNaN(statValue = this.functionTable.call(this.stats[band], this.sampleData, numSamples))) {
                        val = (int)(statValue + 0.5);
                        if (val < 0) {
                            val = 0;
                        } else if (val > 255) {
                            val = 255;
                        }
                    }
                    destBandData[dstPixelOffset] = (byte)val;
                }
                srcPixelOffset += this.srcPixelStride;
                destPixelDelta += this.destPixelStride;
                ++i;
                ++destX;
            }
            srcScanlineOffset += this.srcScanlineStride;
            destLineDelta += this.destScanlineStride;
            ++j;
            ++destY;
        }
    }

    private void calcShortData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        short[][] destData = destAcc.getShortDataArrays();
        short[][] srcData = srcAcc.getShortDataArrays();
        int destY = destAcc.getY();
        int destX = destAcc.getX();
        short[] srcBandData = srcData[this.srcBand];
        int srcScanlineOffset = this.srcBandOffsets[this.srcBand];
        int destLineDelta = 0;
        int j = 0;
        while (j < this.destHeight) {
            int srcPixelOffset = srcScanlineOffset;
            int destPixelDelta = 0;
            int i = 0;
            while (i < this.destWidth) {
                int numSamples = 0;
                if (!this.maskDest || this.roi.contains(destX, destY)) {
                    int srcY = destY - this.kernelKeyY;
                    int kernelVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < this.kernelH) {
                        int srcX = destX - this.kernelKeyX;
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < this.kernelW) {
                            if ((!this.maskSrc || this.roi.contains(srcX, srcY)) && this.inKernel[kernelVerticalOffset + v]) {
                                this.sampleData[numSamples++] = srcBandData[imageOffset];
                            }
                            imageOffset += this.srcPixelStride;
                            ++v;
                            ++srcX;
                        }
                        kernelVerticalOffset += this.kernelW;
                        imageVerticalOffset += this.srcScanlineStride;
                        ++u;
                        ++srcY;
                    }
                }
                for (int band = 0; band < this.destBands; ++band) {
                    double statValue;
                    short[] destBandData = destData[band];
                    int dstPixelOffset = this.destBandOffsets[band] + destPixelDelta + destLineDelta;
                    int val = this.nilValue.shortValue();
                    if (numSamples > 0 && !Double.isNaN(statValue = this.functionTable.call(this.stats[band], this.sampleData, numSamples))) {
                        val = (int)(statValue + 0.5);
                        if (val < Short.MIN_VALUE) {
                            val = Short.MIN_VALUE;
                        } else if (val > Short.MAX_VALUE) {
                            val = Short.MAX_VALUE;
                        }
                    }
                    destBandData[dstPixelOffset] = (short)val;
                }
                srcPixelOffset += this.srcPixelStride;
                destPixelDelta += this.destPixelStride;
                ++i;
                ++destX;
            }
            srcScanlineOffset += this.srcScanlineStride;
            destLineDelta += this.destScanlineStride;
            ++j;
            ++destY;
        }
    }

    private void calcUShortData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        short[][] destData = destAcc.getShortDataArrays();
        short[][] srcData = srcAcc.getShortDataArrays();
        int destY = destAcc.getY();
        int destX = destAcc.getX();
        short[] srcBandData = srcData[this.srcBand];
        int srcScanlineOffset = this.srcBandOffsets[this.srcBand];
        int destLineDelta = 0;
        int j = 0;
        while (j < this.destHeight) {
            int srcPixelOffset = srcScanlineOffset;
            int destPixelDelta = 0;
            int i = 0;
            while (i < this.destWidth) {
                int numSamples = 0;
                if (!this.maskDest || this.roi.contains(destX, destY)) {
                    int srcY = destY - this.kernelKeyY;
                    int kernelVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < this.kernelH) {
                        int srcX = destX - this.kernelKeyX;
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < this.kernelW) {
                            if ((!this.maskSrc || this.roi.contains(srcX, srcY)) && this.inKernel[kernelVerticalOffset + v]) {
                                this.sampleData[numSamples++] = srcBandData[imageOffset] & 0xFFFF;
                            }
                            imageOffset += this.srcPixelStride;
                            ++v;
                            ++srcX;
                        }
                        kernelVerticalOffset += this.kernelW;
                        imageVerticalOffset += this.srcScanlineStride;
                        ++u;
                        ++srcY;
                    }
                }
                for (int band = 0; band < this.destBands; ++band) {
                    double statValue;
                    short[] destBandData = destData[band];
                    int dstPixelOffset = this.destBandOffsets[band] + destPixelDelta + destLineDelta;
                    int val = this.nilValue.shortValue();
                    if (numSamples > 0 && !Double.isNaN(statValue = this.functionTable.call(this.stats[band], this.sampleData, numSamples))) {
                        val = (int)(statValue + 0.5);
                        if (val < 0) {
                            val = 0;
                        } else if (val > 65535) {
                            val = 65535;
                        }
                    }
                    destBandData[dstPixelOffset] = (short)val;
                }
                srcPixelOffset += this.srcPixelStride;
                destPixelDelta += this.destPixelStride;
                ++i;
                ++destX;
            }
            srcScanlineOffset += this.srcScanlineStride;
            destLineDelta += this.destScanlineStride;
            ++j;
            ++destY;
        }
    }

    private void calcIntData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        int[][] destData = destAcc.getIntDataArrays();
        int[][] srcData = srcAcc.getIntDataArrays();
        int destY = destAcc.getY();
        int destX = destAcc.getX();
        int[] srcBandData = srcData[this.srcBand];
        int srcScanlineOffset = this.srcBandOffsets[this.srcBand];
        int destLineDelta = 0;
        int j = 0;
        while (j < this.destHeight) {
            int srcPixelOffset = srcScanlineOffset;
            int destPixelDelta = 0;
            int i = 0;
            while (i < this.destWidth) {
                int numSamples = 0;
                if (!this.maskDest || this.roi.contains(destX, destY)) {
                    int srcY = destY - this.kernelKeyY;
                    int kernelVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < this.kernelH) {
                        int srcX = destX - this.kernelKeyX;
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < this.kernelW) {
                            if ((!this.maskSrc || this.roi.contains(srcX, srcY)) && this.inKernel[kernelVerticalOffset + v]) {
                                this.sampleData[numSamples++] = srcBandData[imageOffset];
                            }
                            imageOffset += this.srcPixelStride;
                            ++v;
                            ++srcX;
                        }
                        kernelVerticalOffset += this.kernelW;
                        imageVerticalOffset += this.srcScanlineStride;
                        ++u;
                        ++srcY;
                    }
                }
                for (int band = 0; band < this.destBands; ++band) {
                    double statValue;
                    int[] destBandData = destData[band];
                    int dstPixelOffset = this.destBandOffsets[band] + destPixelDelta + destLineDelta;
                    int val = this.nilValue.intValue();
                    if (numSamples > 0 && !Double.isNaN(statValue = this.functionTable.call(this.stats[band], this.sampleData, numSamples))) {
                        val = (int)(statValue + 0.5);
                    }
                    destBandData[dstPixelOffset] = val;
                }
                srcPixelOffset += this.srcPixelStride;
                destPixelDelta += this.destPixelStride;
                ++i;
                ++destX;
            }
            srcScanlineOffset += this.srcScanlineStride;
            destLineDelta += this.destScanlineStride;
            ++j;
            ++destY;
        }
    }

    private void calcFloatData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        float[][] destData = destAcc.getFloatDataArrays();
        float[][] srcData = srcAcc.getFloatDataArrays();
        int destY = destAcc.getY();
        int destX = destAcc.getX();
        float[] srcBandData = srcData[this.srcBand];
        int srcScanlineOffset = this.srcBandOffsets[this.srcBand];
        int destLineDelta = 0;
        int j = 0;
        while (j < this.destHeight) {
            int srcPixelOffset = srcScanlineOffset;
            int destPixelDelta = 0;
            int i = 0;
            while (i < this.destWidth) {
                int numSamples = 0;
                if (!this.maskDest || this.roi.contains(destX, destY)) {
                    int srcY = destY - this.kernelKeyY;
                    int kernelVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < this.kernelH) {
                        int srcX = destX - this.kernelKeyX;
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < this.kernelW) {
                            if ((!this.maskSrc || this.roi.contains(srcX, srcY)) && this.inKernel[kernelVerticalOffset + v]) {
                                this.sampleData[numSamples++] = srcBandData[imageOffset];
                            }
                            imageOffset += this.srcPixelStride;
                            ++v;
                            ++srcX;
                        }
                        kernelVerticalOffset += this.kernelW;
                        imageVerticalOffset += this.srcScanlineStride;
                        ++u;
                        ++srcY;
                    }
                }
                for (int band = 0; band < this.destBands; ++band) {
                    double statValue;
                    float[] destBandData = destData[band];
                    int dstPixelOffset = this.destBandOffsets[band] + destPixelDelta + destLineDelta;
                    float val = this.nilValue.floatValue();
                    if (numSamples > 0 && !Double.isNaN(statValue = this.functionTable.call(this.stats[band], this.sampleData, numSamples))) {
                        val = (float)statValue;
                    }
                    destBandData[dstPixelOffset] = val;
                }
                srcPixelOffset += this.srcPixelStride;
                destPixelDelta += this.destPixelStride;
                ++i;
                ++destX;
            }
            srcScanlineOffset += this.srcScanlineStride;
            destLineDelta += this.destScanlineStride;
            ++j;
            ++destY;
        }
    }

    private void calcDoubleData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        double[][] destData = destAcc.getDoubleDataArrays();
        double[][] srcData = srcAcc.getDoubleDataArrays();
        int destY = destAcc.getY();
        int destX = destAcc.getX();
        double[] srcBandData = srcData[this.srcBand];
        int srcScanlineOffset = this.srcBandOffsets[this.srcBand];
        int destLineDelta = 0;
        int j = 0;
        while (j < this.destHeight) {
            int srcPixelOffset = srcScanlineOffset;
            int destPixelDelta = 0;
            int i = 0;
            while (i < this.destWidth) {
                int numSamples = 0;
                if (!this.maskDest || this.roi.contains(destX, destY)) {
                    int srcY = destY - this.kernelKeyY;
                    int kernelVerticalOffset = 0;
                    int imageVerticalOffset = srcPixelOffset;
                    int u = 0;
                    while (u < this.kernelH) {
                        int srcX = destX - this.kernelKeyX;
                        int imageOffset = imageVerticalOffset;
                        int v = 0;
                        while (v < this.kernelW) {
                            if ((!this.maskSrc || this.roi.contains(srcX, srcY)) && this.inKernel[kernelVerticalOffset + v]) {
                                this.sampleData[numSamples++] = srcBandData[imageOffset];
                            }
                            imageOffset += this.srcPixelStride;
                            ++v;
                            ++srcX;
                        }
                        kernelVerticalOffset += this.kernelW;
                        imageVerticalOffset += this.srcScanlineStride;
                        ++u;
                        ++srcY;
                    }
                }
                for (int band = 0; band < this.destBands; ++band) {
                    double statValue;
                    double[] destBandData = destData[band];
                    int dstPixelOffset = this.destBandOffsets[band] + destPixelDelta + destLineDelta;
                    double val = this.nilValue.doubleValue();
                    if (numSamples > 0 && !Double.isNaN(statValue = this.functionTable.call(this.stats[band], this.sampleData, numSamples))) {
                        val = statValue;
                    }
                    destBandData[dstPixelOffset] = val;
                }
                srcPixelOffset += this.srcPixelStride;
                destPixelDelta += this.destPixelStride;
                ++i;
                ++destX;
            }
            srcScanlineOffset += this.srcScanlineStride;
            destLineDelta += this.destScanlineStride;
            ++j;
            ++destY;
        }
    }

    private static class Calculator {
        private boolean ignoreNaN;

        Calculator(boolean ignoreNaN) {
            this.ignoreNaN = ignoreNaN;
        }

        public double call(Statistic stat, Double[] data, int n) {
            Double[] values = null;
            if (data.length == n) {
                values = data;
            } else {
                values = new Double[n];
                System.arraycopy(data, 0, values, 0, n);
            }
            switch (stat) {
                case MAX: {
                    return SampleStats.max(values, this.ignoreNaN);
                }
                case MEAN: {
                    return SampleStats.mean(values, this.ignoreNaN);
                }
                case MEDIAN: {
                    return SampleStats.median(values, this.ignoreNaN);
                }
                case MIN: {
                    return SampleStats.min(values, this.ignoreNaN);
                }
                case RANGE: {
                    return SampleStats.range(values, this.ignoreNaN);
                }
                case SDEV: {
                    return SampleStats.sdev(values, this.ignoreNaN);
                }
                case VARIANCE: {
                    return SampleStats.variance(values, this.ignoreNaN);
                }
                case SUM: {
                    return SampleStats.sum(values, this.ignoreNaN);
                }
            }
            throw new IllegalArgumentException("Unrecognized KernelStatstic arg");
        }
    }
}

