/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.contour;

import java.util.Comparator;
import org.jaitools.jts.Utils;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;

final class Segment {
    static final Comparator<Segment> START_COMPARATOR = new StartComparator();
    static final Comparator<Segment> END_COMPARATOR = new EndComparator();
    static final double EPS = 1.0E-4;
    static final int DEFAULT_SIZE = 32;
    boolean touched = true;
    double[] ordinates;
    int idxFirst;
    int idxLast;
    double xStart;
    double yStart;
    double xEnd;
    double yEnd;
    final boolean simplify;
    double dxStart;
    double dyStart;
    double dxEnd;
    double dyEnd;

    public Segment() {
        this.simplify = false;
    }

    public Segment(double x1, double y1, double x2, double y2, int initialSize, boolean simplify) {
        assert (initialSize % 4 == 0 && initialSize > 0);
        this.setXY(x1, y1, x2, y2);
        this.simplify = simplify;
        this.ordinates = new double[initialSize];
        this.idxLast = this.idxFirst = initialSize / 2;
        this.ordinates[this.idxLast++] = x1;
        this.ordinates[this.idxLast++] = y1;
        this.ordinates[this.idxLast++] = x2;
        this.ordinates[this.idxLast++] = y2;
    }

    public void setXY(double x1, double y1, double x2, double y2) {
        assert (this.ordinates == null);
        this.xStart = x1;
        this.yStart = y1;
        this.xEnd = x2;
        this.yEnd = y2;
        this.xStart = x1;
        this.yStart = y1;
        this.xEnd = x2;
        this.yEnd = y2;
        this.dxEnd = x2 - x1;
        this.dyEnd = y2 - y1;
        this.dxStart = this.dxEnd;
        this.dyStart = this.dyEnd;
    }

    Segment(double x1, double y1, double x2, double y2, boolean simplify) {
        this(x1, y1, x2, y2, 32, simplify);
    }

    private void addAfterEnd(double x, double y, boolean touch) {
        if (this.simplify && this.sameSlope(this.dxEnd, this.dyEnd, x - this.xEnd, y - this.yEnd)) {
            this.ordinates[this.idxLast - 2] = x;
            this.ordinates[this.idxLast - 1] = y;
        } else {
            if (this.idxLast >= this.ordinates.length - 1) {
                int extra = this.ordinates.length / 2;
                double[] newOrdinates = new double[this.ordinates.length + extra];
                System.arraycopy(this.ordinates, 0, newOrdinates, 0, this.ordinates.length);
                this.ordinates = newOrdinates;
                assert (this.isConsistent());
            }
            this.ordinates[this.idxLast++] = x;
            this.ordinates[this.idxLast++] = y;
            if (this.simplify) {
                this.dxEnd = x - this.xEnd;
                this.dyEnd = y - this.yEnd;
            }
        }
        this.xEnd = x;
        this.yEnd = y;
        if (touch) {
            this.touched = true;
        }
    }

    private boolean isConsistent() {
        boolean sameStart = Segment.samePoint(this.xStart, this.yStart, this.ordinates[this.idxFirst], this.ordinates[this.idxFirst + 1]);
        boolean sameEnd = Segment.samePoint(this.xEnd, this.yEnd, this.ordinates[this.idxLast - 2], this.ordinates[this.idxLast - 1]);
        return sameStart && sameEnd;
    }

    public void addAfterEnd(double x, double y) {
        this.addAfterEnd(x, y, true);
    }

    public void addBeforeStart(double x, double y) {
        this.addBeforeStart(x, y, true);
    }

    private void addBeforeStart(double x, double y, boolean touch) {
        if (this.simplify && this.sameSlope(this.dxStart, this.dyStart, this.xStart - x, this.yStart - y)) {
            this.ordinates[this.idxFirst] = x;
            this.ordinates[this.idxFirst + 1] = y;
        } else {
            if (this.idxFirst <= 1) {
                int extra = this.ordinates.length / 2;
                double[] newOrdinates = new double[this.ordinates.length + extra];
                System.arraycopy(this.ordinates, 0, newOrdinates, extra, this.ordinates.length);
                this.ordinates = newOrdinates;
                this.idxFirst += extra;
                this.idxLast += extra;
                assert (this.isConsistent());
            }
            this.ordinates[--this.idxFirst] = y;
            this.ordinates[--this.idxFirst] = x;
            if (this.simplify) {
                this.dxStart = this.xStart - x;
                this.dyStart = this.yStart - y;
            }
        }
        this.xStart = x;
        this.yStart = y;
        if (touch) {
            this.touched = true;
        }
    }

    private boolean sameSlope(double dx1, double dy1, double dx2, double dy2) {
        if (Segment.sameOrdinate(dx1, 0.0)) {
            return Segment.sameOrdinate(dx2, 0.0) && Math.signum(dy1) == Math.signum(dy2);
        }
        if (Segment.sameOrdinate(dx2, 0.0)) {
            return false;
        }
        return Segment.sameOrdinate(dy1 / dx1, dy2 / dx2) && Math.signum(dx1) == Math.signum(dx2);
    }

    public LineString toLineString() {
        double[] ordinates = new double[this.idxLast - this.idxFirst];
        System.arraycopy(this.ordinates, this.idxFirst, ordinates, 0, ordinates.length);
        PackedCoordinateSequence.Double cs = (PackedCoordinateSequence.Double)PackedCoordinateSequenceFactory.DOUBLE_FACTORY.create(ordinates, 2);
        return Utils.getGeometryFactory().createLineString((CoordinateSequence)cs);
    }

    public void merge(Segment other, MergePoint mergePoint) {
        switch (mergePoint) {
            case START_START: {
                this.mergeStartStart(other);
                break;
            }
            case START_END: {
                this.mergeStartEnd(other);
                break;
            }
            case END_START: {
                this.mergeEndStart(other);
                break;
            }
            case END_END: {
                this.mergeEndEnd(other);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized merge point: " + (Object)((Object)mergePoint));
            }
        }
    }

    private void mergeEndEnd(Segment other) {
        int lengthOther = other.idxLast - other.idxFirst - 2;
        if (this.ordinates.length - this.idxLast < lengthOther) {
            int extra = lengthOther - this.ordinates.length + this.idxLast;
            double[] newOrdinates = new double[this.ordinates.length + extra];
            System.arraycopy(this.ordinates, 0, newOrdinates, 0, this.ordinates.length);
            this.ordinates = newOrdinates;
            assert (this.isConsistent());
        }
        if (this.simplify && this.sameSlope(this.dxEnd, this.dyEnd, -other.dxEnd, -other.dyEnd)) {
            this.idxLast -= 2;
        }
        int i = other.idxLast - 2;
        while (i > other.idxFirst) {
            double y = other.ordinates[--i];
            double x = other.ordinates[--i];
            this.ordinates[this.idxLast++] = x;
            this.ordinates[this.idxLast++] = y;
        }
        this.xEnd = other.xStart;
        this.yEnd = other.yStart;
        this.dxEnd = other.dxStart;
        this.dyEnd = other.dyStart;
    }

    private void mergeEndStart(Segment other) {
        int lengthOther = other.idxLast - other.idxFirst - 2;
        if (this.ordinates.length - this.idxLast < lengthOther) {
            int extra = lengthOther - this.ordinates.length + this.idxLast;
            double[] newOrdinates = new double[this.ordinates.length + extra];
            System.arraycopy(this.ordinates, 0, newOrdinates, 0, this.ordinates.length);
            this.ordinates = newOrdinates;
            assert (this.isConsistent());
        }
        if (this.simplify && this.sameSlope(this.dxEnd, this.dyEnd, other.dxStart, other.dyStart)) {
            this.idxLast -= 2;
        }
        System.arraycopy(other.ordinates, other.idxFirst + 2, this.ordinates, this.idxLast, lengthOther);
        this.idxLast += lengthOther;
        this.xEnd = other.xEnd;
        this.yEnd = other.yEnd;
        this.dxEnd = other.dxEnd;
        this.dyEnd = other.dyEnd;
    }

    private void mergeStartEnd(Segment other) {
        int lengthOther = other.idxLast - other.idxFirst - 2;
        if (this.idxFirst < lengthOther) {
            int extra = lengthOther - this.idxFirst;
            double[] newOrdinates = new double[this.ordinates.length + extra];
            System.arraycopy(this.ordinates, 0, newOrdinates, extra, this.ordinates.length);
            this.ordinates = newOrdinates;
            this.idxFirst += extra;
            this.idxLast += extra;
            assert (this.isConsistent());
        }
        if (this.simplify && this.sameSlope(this.dxStart, this.dyStart, other.dxEnd, other.dyEnd)) {
            this.idxFirst += 2;
        }
        int i = other.idxLast - 2;
        while (i > other.idxFirst) {
            double y = other.ordinates[--i];
            double x = other.ordinates[--i];
            this.ordinates[--this.idxFirst] = y;
            this.ordinates[--this.idxFirst] = x;
        }
        this.xStart = other.xStart;
        this.yStart = other.yStart;
        this.dxStart = other.dxEnd;
        this.dyStart = other.dyEnd;
    }

    private void mergeStartStart(Segment other) {
        int lengthOther = other.idxLast - other.idxFirst - 2;
        if (this.idxFirst < lengthOther) {
            int extra = lengthOther - this.idxFirst;
            double[] newOrdinates = new double[this.ordinates.length + extra];
            System.arraycopy(this.ordinates, 0, newOrdinates, extra, this.ordinates.length);
            this.ordinates = newOrdinates;
            this.idxFirst += extra;
            this.idxLast += extra;
            assert (this.isConsistent());
        }
        if (this.simplify && this.sameSlope(this.dxStart, this.dyStart, -other.dxStart, -other.dyStart)) {
            this.idxFirst += 2;
        }
        int i = other.idxFirst + 2;
        while (i < other.idxLast) {
            double x = other.ordinates[i++];
            double y = other.ordinates[i++];
            this.ordinates[--this.idxFirst] = y;
            this.ordinates[--this.idxFirst] = x;
        }
        this.xStart = other.xEnd;
        this.yStart = other.yEnd;
        this.dxStart = -other.dxEnd;
        this.dyStart = -other.dyEnd;
    }

    static boolean samePoint(double x1, double y1, double x2, double y2) {
        return Segment.sameOrdinate(x1, x2) && Segment.sameOrdinate(y1, y2);
    }

    static boolean sameOrdinate(double o1, double o2) {
        return Math.abs(o1 - o2) < 1.0E-4;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Segment");
        if (this.touched) {
            sb.append("*");
        }
        sb.append("(").append(this.xStart).append(" ").append(this.yStart).append(", ").append(this.xEnd).append(" ").append(this.yEnd).append(")");
        sb.append("[");
        int i = this.idxFirst;
        while (i < this.idxLast) {
            sb.append(this.ordinates[i++]).append(" ");
            sb.append(this.ordinates[i++]);
            if (i >= this.idxLast) continue;
            sb.append(", ");
        }
        return sb.append("]").toString();
    }

    int getNumCoordinates() {
        return (this.idxLast - this.idxFirst) / 2;
    }

    private static final class EndComparator
    implements Comparator<Segment> {
        private EndComparator() {
        }

        @Override
        public int compare(Segment s1, Segment s2) {
            double difference = s1.xEnd - s2.xEnd;
            if (Math.abs(difference) < 1.0E-4 && Math.abs(difference = s1.yEnd - s2.yEnd) < 1.0E-4) {
                return 0;
            }
            return (int)Math.signum(difference);
        }
    }

    private static final class StartComparator
    implements Comparator<Segment> {
        private StartComparator() {
        }

        @Override
        public int compare(Segment s1, Segment s2) {
            double difference = s1.xStart - s2.xStart;
            if (Math.abs(difference) < 1.0E-4 && Math.abs(difference = s1.yStart - s2.yStart) < 1.0E-4) {
                return 0;
            }
            return (int)Math.signum(difference);
        }
    }

    static enum MergePoint {
        START_START,
        START_END,
        END_START,
        END_END;

    }
}

