/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.demo;

import java.awt.image.RenderedImage;
import java.util.Random;
import javax.media.jai.TiledImage;
import org.jaitools.imageutils.ImageUtils;

public class DemoImages {
    public static RenderedImage createChessboardImage(int width, int height) {
        TiledImage image = ImageUtils.createConstantImage((int)width, (int)height, (Number)0.0);
        int squareWidth = Math.max(width / 8, height / 8);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                boolean isOddCol;
                boolean isOddRow = Math.floor(y / squareWidth) % 2.0 == 1.0;
                boolean bl = isOddCol = Math.floor(x / squareWidth) % 2.0 == 1.0;
                if (!(isOddRow ^ isOddCol)) continue;
                image.setSample(x, y, 0, 1);
            }
        }
        return image;
    }

    public static RenderedImage createInterferenceImage(int width, int height) {
        TiledImage image = ImageUtils.createConstantImage((int)width, (int)height, (Number)0.0);
        for (int y = 0; y < height; ++y) {
            double dy = (double)y / (double)height - 0.5;
            for (int x = 0; x < width; ++x) {
                double dx = (double)x / (double)width - 0.5;
                double dxy = Math.sqrt(dx * dx + dy * dy);
                image.setSample(x, y, 0, Math.sin(dx * 100.0) + Math.sin(dxy * 100.0));
            }
        }
        return image;
    }

    public static RenderedImage createRipplesImage(int width, int height) {
        int xc = width / 2;
        int yc = height / 2;
        TiledImage image = ImageUtils.createConstantImage((int)width, (int)height, (Number)0.0);
        for (int y = 0; y < height; ++y) {
            double dy = (double)(y - yc) / (double)yc;
            for (int x = 0; x < width; ++x) {
                double dx = (double)(x - xc) / (double)xc;
                double d = Math.sqrt(dx * dx + dy * dy);
                image.setSample(x, y, 0, Math.sin(Math.PI * 8 * d));
            }
        }
        return image;
    }

    public static RenderedImage createSquircleImage(int width, int height) {
        int w = width - 1;
        int h = height - 1;
        TiledImage image = ImageUtils.createConstantImage((int)width, (int)height, (Number)0.0);
        for (int y = 0; y < height; ++y) {
            double dy = Math.PI * 4 * (0.5 - (double)y / (double)h);
            for (int x = 0; x < width; ++x) {
                double dx = Math.PI * 4 * (0.5 - (double)x / (double)w);
                image.setSample(x, y, 0, Math.sqrt(Math.abs(Math.cos(dx) + Math.cos(dy))));
            }
        }
        return image;
    }

    public static RenderedImage createUniformRandomImage(int width, int height, double maxValue) {
        TiledImage image = ImageUtils.createConstantImage((int)width, (int)height, (Number)0.0);
        Random rr = new Random();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                image.setSample(x, y, 0, rr.nextDouble() * maxValue);
            }
        }
        return image;
    }

    public static RenderedImage createStripedImage(int width, int height, int numBands) {
        int stripeWidth = (int)Math.ceil((double)height / (double)numBands);
        int stripe = 0;
        TiledImage image = ImageUtils.createConstantImage((int)width, (int)height, (Number)0);
        for (int y = 0; y < height; ++y) {
            if (y % stripeWidth == 0) {
                ++stripe;
            }
            for (int x = 0; x < width; ++x) {
                image.setSample(x, y, 0, stripe);
            }
        }
        return image;
    }
}

