/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.demo.iterators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jaitools.imageutils.ImageUtils;
import org.jaitools.imageutils.iterator.WindowIterator;
import org.jaitools.imageutils.iterator.WritableSimpleIterator;
import org.jaitools.swing.SimpleImagePane;

public class VoterModel {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 300;
    private static final int MAX_ITERATIONS = 50;
    private static final long DELAY = 500L;
    private final WritableRenderedImage[] images;
    private final Random rand = new Random();
    private VoterModelFrame frame;

    public static void main(String[] args) {
        new VoterModel().runDemo();
    }

    public VoterModel() {
        this.images = new WritableRenderedImage[2];
        this.images[0] = ImageUtils.createConstantImage((int)300, (int)300, (Number)0);
        this.images[1] = ImageUtils.createConstantImage((int)300, (int)300, (Number)0);
    }

    private void runDemo() {
        int sourceImage = 0;
        int destImage = 1;
        this.fillRandom(this.images[sourceImage]);
        Dimension winDim = new Dimension(3, 3);
        Point keyElement = new Point(1, 1);
        WindowIterator winIter = null;
        int[][] dataWindow = null;
        WritableSimpleIterator writeIter = null;
        this.showFrame(this.images[sourceImage]);
        for (int iter = 1; iter <= 50; ++iter) {
            winIter = new WindowIterator((RenderedImage)this.images[sourceImage], null, winDim, keyElement);
            writeIter = new WritableSimpleIterator(this.images[destImage], null, null);
            do {
                dataWindow = winIter.getWindowInt(dataWindow);
                Point nbr = this.getRandomNbr(winDim, keyElement);
                writeIter.setSample((Number)dataWindow[nbr.y][nbr.x]);
            } while (winIter.next() && writeIter.next());
            this.updateFrame(this.images[destImage], iter);
            ++sourceImage;
            sourceImage %= 2;
            ++destImage;
            destImage %= 2;
        }
    }

    private void fillRandom(WritableRenderedImage image) {
        WritableSimpleIterator iter = new WritableSimpleIterator(image, null, null);
        do {
            int value = this.rand.nextInt(2);
            iter.setSample(0, (Number)value);
        } while (iter.next());
    }

    private Point getRandomNbr(Dimension winDim, Point keyElement) {
        Point nbr = new Point();
        do {
            nbr.setLocation(this.rand.nextInt(winDim.width), this.rand.nextInt(winDim.height));
        } while (nbr.equals(keyElement));
        return nbr;
    }

    private void showFrame(RenderedImage image) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VoterModel.this.frame = new VoterModelFrame();
                VoterModel.this.frame.setVisible(true);
            }
        });
        this.updateFrame(image, 0);
    }

    private void updateFrame(final RenderedImage image, final int iter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((VoterModel)VoterModel.this).frame.imagePane.setImage(image);
                ((VoterModel)VoterModel.this).frame.statusLine.setText(String.format("Iteration %d of %d", iter, 50));
            }
        });
        this.pause();
    }

    private void pause() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class VoterModelFrame
    extends JFrame {
        SimpleImagePane imagePane;
        JLabel statusLine;

        public VoterModelFrame() {
            super("Voter model");
            this.setSize(300, 321);
            this.setResizable(false);
            this.setDefaultCloseOperation(3);
            JPanel panel = new JPanel(new BorderLayout());
            this.imagePane = new SimpleImagePane();
            panel.add((Component)this.imagePane, "Center");
            this.statusLine = new JLabel("Starting...");
            panel.add((Component)this.statusLine, "South");
            this.add(panel);
        }
    }
}

