/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.demo.rangelookup;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.jaitools.demo.DemoImages;
import org.jaitools.media.jai.rangelookup.RangeLookupTable;
import org.jaitools.numeric.Range;
import org.jaitools.swing.ImageFrame;

public class RangeLookupDemo {
    public static void main(String[] args) {
        RangeLookupDemo me = new RangeLookupDemo();
        me.demo();
    }

    private void demo() {
        double maxValue = 1.0;
        RenderedImage image = DemoImages.createUniformRandomImage(300, 300, 1.0);
        ImageFrame frame = new ImageFrame(image, "RangeLookup: source image");
        frame.setVisible(true);
        this.doLookup(image, 1.0);
    }

    private void doLookup(RenderedImage dataImage, double maxImageValue) {
        double bandWidth = maxImageValue / 5.0;
        RangeLookupTable.Builder builder = new RangeLookupTable.Builder();
        double lo = -1.0;
        double hi = bandWidth;
        int destValue = 1;
        do {
            if (destValue != 3) {
                builder.add(Range.create((Number)lo, (boolean)false, (Number)hi, (boolean)true), (Number)destValue);
            }
            lo = hi;
            hi += bandWidth;
            ++destValue;
        } while (lo <= maxImageValue);
        RangeLookupTable table = builder.build();
        ParameterBlockJAI pb = new ParameterBlockJAI("RangeLookup");
        pb.setSource("source0", (Object)dataImage);
        pb.setParameter("table", (Object)table);
        RenderedOp resultImg = JAI.create((String)"RangeLookup", (ParameterBlock)pb);
        ImageFrame frame = new ImageFrame((RenderedImage)resultImg, "RangeLookup result");
        frame.setVisible(true);
    }
}

