/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.demo.regionalize;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.jaitools.CollectionFactory;
import org.jaitools.demo.DemoImages;
import org.jaitools.imageutils.ImageUtils;
import org.jaitools.media.jai.regionalize.Region;
import org.jaitools.swing.ImageFrame;

public class RegionalizeDemo {
    public static void main(String[] args) {
        RegionalizeDemo me = new RegionalizeDemo();
        me.demo();
    }

    public void demo() {
        RenderedImage image = DemoImages.createChessboardImage(320, 320);
        ImageFrame frame = new ImageFrame(image, "Regionalize demo: test image");
        frame.setVisible(true);
        this.regionalizeImage(image);
    }

    public void regionalizeImage(RenderedImage image) {
        ParameterBlockJAI pb = new ParameterBlockJAI("regionalize");
        pb.setSource("source0", (Object)image);
        pb.setParameter("diagonal", false);
        RenderedOp orthoImg = JAI.create((String)"Regionalize", (ParameterBlock)pb);
        orthoImg.getData();
        List regions = (List)orthoImg.getProperty("regiondata");
        for (Region r : regions) {
            System.out.println(r);
        }
        Color[] colors = ImageUtils.createRampColours((int)regions.size());
        Map colorMap = CollectionFactory.map();
        int k = 0;
        for (Region r : regions) {
            colorMap.put(r.getId(), colors[k++]);
        }
        RenderedImage displayImg = ImageUtils.createDisplayImage((RenderedImage)orthoImg, (Map)colorMap);
        ImageFrame frame = new ImageFrame(displayImg, (RenderedImage)orthoImg, "Regions with orthogonal connection");
        frame.setVisible(true);
        pb = new ParameterBlockJAI("regionalize");
        pb.setSource("source0", (Object)image);
        pb.setParameter("diagonal", true);
        RenderedOp diagImg = JAI.create((String)"regionalize", (ParameterBlock)pb);
        colorMap.clear();
        colorMap.put(1, Color.CYAN);
        colorMap.put(2, Color.ORANGE);
        RenderedImage diagDisplayImg = ImageUtils.createDisplayImage((RenderedImage)diagImg, (Map)colorMap);
        frame = new ImageFrame(diagDisplayImg, (RenderedImage)diagImg, "Regions with diagonal connection");
        frame.setVisible(true);
    }
}

