/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.demo.tilecache;

import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.renderable.ParameterBlock;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.jaitools.tilecache.DiskCachedTile;
import org.jaitools.tilecache.DiskMemTileCache;

public class TileCacheDemo
implements Observer {
    private static final int TILE_WIDTH = 128;
    private static final int IMAGE_WIDTH = 384;
    private static final int IMAGE_HEIGHT = 256;

    public static void main(String[] args) {
        TileCacheDemo me = new TileCacheDemo();
        me.demo();
    }

    private void demo() {
        HashMap<String, Long> cacheParams = new HashMap<String, Long>();
        cacheParams.put("memcapacity", 0x100000L);
        DiskMemTileCache cache = new DiskMemTileCache(cacheParams);
        cache.setDiagnostics(true);
        cache.addObserver((Observer)this);
        ImageLayout layout = new ImageLayout();
        layout.setTileWidth(128);
        layout.setTileHeight(128);
        HashMap<RenderingHints.Key, Object> imgParams = new HashMap<RenderingHints.Key, Object>();
        imgParams.put(JAI.KEY_IMAGE_LAYOUT, layout);
        imgParams.put(JAI.KEY_TILE_CACHE, cache);
        RenderingHints hints = new RenderingHints(imgParams);
        ParameterBlockJAI pb = new ParameterBlockJAI("constant");
        pb.setParameter("width", 384.0f);
        pb.setParameter("height", 256.0f);
        pb.setParameter("bandValues", (Object)new Double[]{0.0, 1.0, 2.0});
        RenderedOp op1 = JAI.create((String)"constant", (ParameterBlock)pb, (RenderingHints)hints);
        pb = new ParameterBlockJAI("MultiplyConst");
        pb.setSource("source0", (Object)op1);
        pb.setParameter("constants", (Object)new double[]{2.0});
        RenderedOp op2 = JAI.create((String)"MultiplyConst", (ParameterBlock)pb, (RenderingHints)hints);
        System.out.println("Requesting tiles. Cache has only enough memory capacity");
        System.out.println("for 2 tiles");
        System.out.println();
        Raster[] tiles = op2.getTiles();
        System.out.println(String.format("%d tiles cached; %d resident in memory", cache.getNumTiles(), cache.getNumResidentTiles()));
        cache.setMemoryCapacity(0x500000L);
        System.out.println();
        System.out.println("Repeating the tile request after increasing the");
        System.out.println("memory capacity of the cache");
        System.out.println();
        tiles = op2.getTiles();
        System.out.println(String.format("%d tiles cached; %d resident in memory", cache.getNumTiles(), cache.getNumResidentTiles()));
    }

    public void update(Observable ocache, Object otile) {
        DiskCachedTile tile = (DiskCachedTile)otile;
        StringBuffer sb = new StringBuffer();
        sb.append("Tile at ");
        sb.append(tile.getLocation());
        sb.append(" ");
        int actionValue = tile.getAction();
        sb.append(DiskCachedTile.TileAction.get((int)actionValue).getDescription());
        System.out.println(sb.toString());
    }
}

