/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.demo.tiledimage;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import org.jaitools.swing.ImageFrame;
import org.jaitools.tiledimage.DiskMemImage;

public class DrawingDemo {
    private final int TILE_SIZE = 128;
    private final int IMAGE_SIZE = 512;

    public static void main(String[] args) {
        DrawingDemo me = new DrawingDemo();
        me.basicDrawing();
        me.clippingDemo();
    }

    private void basicDrawing() {
        DiskMemImage image = this.createImage();
        Graphics2D gr = image.createGraphics();
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr.setBackground(Color.ORANGE);
        gr.clearRect(0, 0, 512, 512);
        gr.setColor(Color.BLUE);
        gr.setStroke(new BasicStroke(3.0f));
        int iy = 0;
        for (int y = image.getMinY(); y < image.getMaxY(); y += 128) {
            int ix = 0;
            for (int x = image.getMinX(); x < image.getMaxX(); x += 128) {
                if ((ix + iy) % 2 == 0) {
                    Rectangle r = new Rectangle(x, y, 128, 128);
                    gr.fill(r);
                }
                ++ix;
            }
            ++iy;
        }
        Graphics2D child = (Graphics2D)gr.create();
        AffineTransform tr = AffineTransform.getRotateInstance(0.7853981633974483, 256.0, 256.0);
        child.setTransform(tr);
        child.setColor(Color.BLACK);
        Font font = gr.getFont();
        child.setFont(font.deriveFont(48.0f));
        child.drawString("Hello World !", 85, 256);
        ImageFrame.showImage((RenderedImage)image, (String)"Drawing demo");
    }

    private void clippingDemo() {
        DiskMemImage image = this.createImage();
        Graphics2D gr = image.createGraphics();
        gr.clip(new Rectangle(0, 0, 256, 256));
        gr.setPaint(new LinearGradientPaint(new Point(0, 0), new Point(512, 512), new float[]{0.0f, 0.5f}, new Color[]{Color.BLACK, Color.WHITE}));
        gr.fill(image.getBounds());
        gr.transform(AffineTransform.getRotateInstance(0.7853981633974483, 256.0, 256.0));
        gr.setPaint(Color.RED);
        gr.setStroke(new BasicStroke(5.0f));
        int x = 156;
        int w = 100;
        gr.draw(new Rectangle(x, x, w, w));
        gr.clip(null);
        gr.setPaint(Color.BLACK);
        gr.setStroke(new BasicStroke(3.0f, 0, 0, 1.0f, new float[]{5.0f, 5.0f}, 0.0f));
        gr.draw(new Rectangle(x, x, w, w));
        ImageFrame.showImage((RenderedImage)image, (String)"foo");
    }

    private DiskMemImage createImage() {
        ColorModel cm = ColorModel.getRGBdefault();
        SampleModel sm = cm.createCompatibleSampleModel(128, 128);
        return new DiskMemImage(0, 0, 512, 512, 0, 0, sm, cm);
    }
}

