/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.demo.vectorize;

import com.vividsolutions.jts.geom.Polygon;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import org.jaitools.imageutils.ImageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorizeDemo {
    public static void main(String[] args) {
        VectorizeDemo me = new VectorizeDemo();
        me.demo();
    }

    private void demo() {
        int JAI_TILE_WIDTH = 128;
        int IMAGE_WIDTH = 240;
        int SQUARE_WIDTH = 30;
        JAI.setDefaultTileSize((Dimension)new Dimension(128, 128));
        TiledImage src = ImageUtils.createConstantImage((int)240, (int)240, (Number)0);
        HashMap<String, Object> args = new HashMap<String, Object>();
        for (int y = 0; y < 240; ++y) {
            int ysquare = y / 30;
            for (int x = 0; x < 240; ++x) {
                int xsquare = x / 30;
                if (xsquare % 2 != ysquare % 2) continue;
                src.setSample(x, y, 0, 1);
            }
        }
        System.out.println("Source image is a chessboard pattern.");
        System.out.printf("Image bounds: %d x %d \n", 240, 240);
        System.out.printf("Chessboard squares: %d x %d \n", 30, 30);
        System.out.println("Vectorizing:");
        System.out.println("With default arguments...");
        Collection<Polygon> polys = this.doVectorize((RenderedImage)src, args);
        this.printPolys(polys, 5);
        System.out.println("With 0 as an outside value...");
        args.put("outsideValues", Collections.singleton(0));
        polys = this.doVectorize((RenderedImage)src, args);
        this.printPolys(polys, 5);
        System.out.println("With insideEdges arg set to false...");
        args.clear();
        args.put("insideEdges", Boolean.FALSE);
        polys = this.doVectorize((RenderedImage)src, args);
        this.printPolys(polys, 1);
        System.out.println("With an ROI over central 4x4 chessboard squares...");
        args.clear();
        ROIShape roi = new ROIShape((Shape)new Rectangle(60, 60, 120, 120));
        args.put("roi", roi);
        polys = this.doVectorize((RenderedImage)src, args);
        this.printPolys(polys, 5);
    }

    private Collection<Polygon> doVectorize(RenderedImage src, Map<String, Object> args) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Vectorize");
        pb.setSource("source0", (Object)src);
        for (Map.Entry<String, Object> e : args.entrySet()) {
            pb.setParameter(e.getKey(), e.getValue());
        }
        RenderedOp dest = JAI.create((String)"Vectorize", (ParameterBlock)pb);
        Object property = dest.getProperty("vectors");
        return (Collection)property;
    }

    private void printPolys(Collection<Polygon> polys, int nlist) {
        int n = polys.size();
        System.out.printf("   Got %d polygon%s \n", n, n == 1 ? "" : "s");
        nlist = Math.min(nlist, polys.size());
        if (nlist > 0) {
            int k;
            Iterator<Polygon> iter = polys.iterator();
            for (k = 0; k < nlist; ++k) {
                Polygon p = iter.next();
                p.normalize();
                System.out.println("   " + p.toText());
                System.out.println("   Image value: " + p.getUserData());
            }
            if (k < polys.size()) {
                System.out.println("   ...");
            }
            System.out.println();
        }
    }
}

