/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.demo.zonalstats;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Iterator;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.jaitools.demo.DemoImages;
import org.jaitools.media.jai.zonalstats.Result;
import org.jaitools.media.jai.zonalstats.ZonalStats;
import org.jaitools.numeric.Statistic;

public class ZonalStatsDemo {
    private RenderedImage dataImg = DemoImages.createUniformRandomImage(500, 500, 10.0);
    private RenderedImage zoneImg = DemoImages.createStripedImage(500, 500, 5);

    public static void main(String[] args) throws Exception {
        ZonalStatsDemo me = new ZonalStatsDemo();
        me.demo();
    }

    private void demo() {
        ParameterBlockJAI pb = new ParameterBlockJAI("zonalstats");
        pb.setSource("dataImage", (Object)this.dataImg);
        pb.setSource("zoneImage", (Object)this.zoneImg);
        Statistic[] statistics = new Statistic[]{Statistic.MIN, Statistic.MAX, Statistic.MEDIAN, Statistic.APPROX_MEDIAN, Statistic.SDEV};
        pb.setParameter("stats", (Object)statistics);
        RenderedOp zsImg = JAI.create((String)"zonalstats", (ParameterBlock)pb);
        ZonalStats zs = (ZonalStats)zsImg.getProperty("ZonalStatsProperty");
        System.out.println("                               exact    approx");
        System.out.println(" band zone      min      max   median   median     sdev");
        System.out.println("-----------------------------------------------------------");
        boolean band = false;
        Iterator i$ = zs.getZones().iterator();
        while (i$.hasNext()) {
            int z = (Integer)i$.next();
            System.out.printf(" %4d %4d", 0, z);
            ZonalStats zoneSubset = zs.band(0).zone(z);
            for (Statistic s : statistics) {
                System.out.printf(" %8.4f", ((Result)zoneSubset.statistic(s).results().get(0)).getValue());
            }
            System.out.println();
        }
    }
}

