/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.demo.jiffle;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.File;
import java.util.Map;
import javax.media.jai.TiledImage;
import org.jaitools.CollectionFactory;
import org.jaitools.demo.ImageChoice;
import org.jaitools.demo.jiffle.JiffleDemoBase;
import org.jaitools.demo.jiffle.JiffleDemoHelper;
import org.jaitools.imageutils.ImageUtils;
import org.jaitools.jiffle.Jiffle;
import org.jaitools.jiffle.runtime.JiffleDirectRuntime;
import org.jaitools.swing.ImageFrame;

public class DirectRuntimeDemo
extends JiffleDemoBase {
    public static void main(String[] args) throws Exception {
        DirectRuntimeDemo demo = new DirectRuntimeDemo();
        File f = JiffleDemoHelper.getScriptFile(args, ImageChoice.RIPPLES);
        demo.compileAndRun(f);
    }

    public void compileAndRun(File scriptFile) throws Exception {
        Map imageParams = CollectionFactory.map();
        imageParams.put("result", Jiffle.ImageRole.DEST);
        Jiffle jiffle = new Jiffle(scriptFile, imageParams);
        Map images = CollectionFactory.map();
        images.put("result", ImageUtils.createConstantImage((int)500, (int)500, (Number)0.0));
        if (jiffle.isCompiled()) {
            JiffleDirectRuntime runtime = jiffle.getRuntimeInstance();
            TiledImage destImg = ImageUtils.createConstantImage((int)500, (int)500, (Number)0.0);
            runtime.setDestinationImage("result", (WritableRenderedImage)destImg);
            runtime.evaluateAll(null);
            ImageFrame frame = new ImageFrame((RenderedImage)destImg, "Jiffle image demo");
            frame.setVisible(true);
        }
    }
}

