/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.demo.jiffle;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.File;
import java.util.Map;
import javax.media.jai.TiledImage;
import org.jaitools.CollectionFactory;
import org.jaitools.demo.ImageChoice;
import org.jaitools.demo.jiffle.JiffleDemoBase;
import org.jaitools.demo.jiffle.JiffleDemoHelper;
import org.jaitools.imageutils.ImageUtils;
import org.jaitools.jiffle.Jiffle;
import org.jaitools.jiffle.runtime.JiffleDirectRuntime;
import org.jaitools.jiffle.runtime.JiffleEvent;
import org.jaitools.jiffle.runtime.JiffleEventListener;
import org.jaitools.jiffle.runtime.JiffleExecutor;
import org.jaitools.jiffle.runtime.JiffleExecutorResult;
import org.jaitools.jiffle.runtime.JiffleProgressListener;
import org.jaitools.jiffle.runtime.NullProgressListener;
import org.jaitools.swing.ImageFrame;

public class JiffleExecutorDemo
extends JiffleDemoBase {
    private JiffleExecutor executor = new JiffleExecutor(1);

    public static void main(String[] args) throws Exception {
        JiffleExecutorDemo demo = new JiffleExecutorDemo();
        File f = JiffleDemoHelper.getScriptFile(args, ImageChoice.RIPPLES);
        demo.compileAndRun(f);
    }

    public JiffleExecutorDemo() {
        this.executor.addEventListener(new JiffleEventListener(){

            public void onCompletionEvent(JiffleEvent ev) {
                JiffleExecutorDemo.this.onCompletion(ev);
            }

            public void onFailureEvent(JiffleEvent ev) {
                JiffleExecutorDemo.this.onFailure(ev);
            }
        });
    }

    public void compileAndRun(File scriptFile) throws Exception {
        Map imageParams = CollectionFactory.map();
        imageParams.put("result", Jiffle.ImageRole.DEST);
        Jiffle jiffle = new Jiffle(scriptFile, imageParams);
        JiffleDirectRuntime runtime = jiffle.getRuntimeInstance();
        TiledImage destImage = ImageUtils.createConstantImage((int)500, (int)500, (Number)0.0);
        runtime.setDestinationImage("result", (WritableRenderedImage)destImage);
        this.executor.submit(runtime, (JiffleProgressListener)new NullProgressListener());
    }

    private void onCompletion(JiffleEvent ev) {
        JiffleExecutorResult result = ev.getResult();
        RenderedImage img = (RenderedImage)result.getImages().get("result");
        ImageFrame frame = new ImageFrame(img, "Jiffle image demo");
        frame.setVisible(true);
    }

    private void onFailure(JiffleEvent ev) {
        System.err.println("Bummer: script failed to run");
    }
}

