/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.maskedconvolve;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import org.jaitools.CollectionFactory;
import org.jaitools.numeric.CompareOp;
import org.jaitools.numeric.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskedConvolveOpImage
extends AreaOpImage {
    private int[] srcBandOffsets;
    private int srcPixelStride;
    private int srcScanlineStride;
    private int destWidth;
    private int destHeight;
    private int destBands;
    private int[] dstBandOffsets;
    private int dstPixelStride;
    private int dstScanlineStride;
    private final float[] kernelData;
    private final int kernelW;
    private final int kernelH;
    private final int kernelKeyX;
    private final int kernelKeyY;
    private final boolean[] kernelActive;
    public static final float KERNEL_TOL = 1.0E-6f;
    private final ROI roi;
    private final boolean maskSrc;
    private final boolean maskDest;
    private final boolean noDataDefined;
    private final boolean strictNodata;
    private final List<Double> noDataNumbers;
    private final List<Range<Double>> noDataRanges;
    private final Number nilValueNumber;
    private final int minKernelCells;

    public MaskedConvolveOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, KernelJAI kernel, ROI roi, Boolean maskSrc, Boolean maskDest, Number nilValue, int minCells, Collection<Object> noDataValues, Boolean strictNodata) {
        super(source, layout, config, true, extender, kernel.getLeftPadding(), kernel.getRightPadding(), kernel.getTopPadding(), kernel.getBottomPadding());
        Rectangle sourceBounds = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
        if (!roi.getBounds().contains(sourceBounds)) {
            throw new IllegalArgumentException("The bounds of the ROI must contain the source image");
        }
        this.roi = roi;
        this.maskSrc = maskSrc;
        this.maskDest = maskDest;
        try {
            Constructor<?> ctor = nilValue.getClass().getConstructor(String.class);
            this.nilValueNumber = (Number)ctor.newInstance(nilValue.toString());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Problem copying nilValue arg", ex);
        }
        this.kernelData = kernel.getKernelData();
        this.kernelActive = new boolean[this.kernelData.length];
        for (int i = 0; i < this.kernelData.length; ++i) {
            this.kernelActive[i] = Math.abs(this.kernelData[i]) > 1.0E-6f;
        }
        this.kernelW = kernel.getWidth();
        this.kernelH = kernel.getHeight();
        this.kernelKeyX = kernel.getXOrigin();
        this.kernelKeyY = kernel.getYOrigin();
        this.minKernelCells = minCells;
        if (noDataValues != null && !noDataValues.isEmpty()) {
            this.noDataDefined = true;
            this.strictNodata = strictNodata;
            this.noDataNumbers = CollectionFactory.list();
            this.noDataRanges = CollectionFactory.list();
            for (Object oelem : noDataValues) {
                if (oelem instanceof Number) {
                    double dz = ((Number)oelem).doubleValue();
                    this.noDataNumbers.add(dz);
                    continue;
                }
                if (oelem instanceof Range) {
                    Range r = (Range)oelem;
                    Double min = r.getMin().doubleValue();
                    Double max = r.getMax().doubleValue();
                    Range rd = new Range((Number)min, r.isMinIncluded(), (Number)max, r.isMaxIncluded());
                    this.noDataRanges.add((Range<Double>)rd);
                    continue;
                }
                throw new IllegalArgumentException("only Number and Range elements are permitted in the noDataValues Collection");
            }
        } else {
            this.noDataDefined = false;
            this.strictNodata = false;
            this.noDataNumbers = null;
            this.noDataRanges = null;
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAcc = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor destAcc = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        this.convolve(srcAcc, destAcc);
    }

    private void convolve(RasterAccessor srcAcc, RasterAccessor destAcc) {
        this.destWidth = destAcc.getWidth();
        this.destHeight = destAcc.getHeight();
        this.destBands = destAcc.getNumBands();
        this.dstBandOffsets = destAcc.getBandOffsets();
        this.dstPixelStride = destAcc.getPixelStride();
        this.dstScanlineStride = destAcc.getScanlineStride();
        this.srcBandOffsets = srcAcc.getBandOffsets();
        this.srcPixelStride = srcAcc.getPixelStride();
        this.srcScanlineStride = srcAcc.getScanlineStride();
        switch (destAcc.getDataType()) {
            case 0: {
                this.convolveAsByteData(srcAcc, destAcc);
                break;
            }
            case 3: {
                this.convolveAsIntData(srcAcc, destAcc);
                break;
            }
            case 2: {
                this.convolveAsShortData(srcAcc, destAcc);
                break;
            }
            case 1: {
                this.convolveAsUShortData(srcAcc, destAcc);
                break;
            }
            case 4: {
                this.convolveAsFloatData(srcAcc, destAcc);
                break;
            }
            case 5: {
                this.convolveAsDoubleData(srcAcc, destAcc);
            }
        }
        if (destAcc.isDataCopy()) {
            destAcc.clampDataArrays();
            destAcc.copyDataToRaster();
        }
    }

    private boolean isNoData(double value) {
        if (this.noDataDefined) {
            for (Double d : this.noDataNumbers) {
                if (!CompareOp.aequal((double)value, (double)d)) continue;
                return true;
            }
            for (Range range : this.noDataRanges) {
                if (!range.contains((Number)value)) continue;
                return true;
            }
        }
        return false;
    }

    private void convolveAsByteData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        byte[][] srcData = srcAcc.getByteDataArrays();
        byte[][] destData = destAcc.getByteDataArrays();
        int nilValue = this.nilValueNumber.intValue();
        for (int k = 0; k < this.destBands; ++k) {
            int destY = destAcc.getY();
            byte[] destBandData = destData[k];
            byte[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    int val = 0;
                    int count = 0;
                    float convSum = 0.5f;
                    boolean hasResult = true;
                    if (!this.maskDest || this.roi.contains(destX, destY)) {
                        int srcY = destY - this.kernelKeyY;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (hasResult && u < this.kernelH) {
                            int srcX = destX - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (hasResult && v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    float fval = srcBandData[imageOffset] & 0xFF;
                                    if (this.isNoData(fval)) {
                                        if (this.strictNodata) {
                                            hasResult = false;
                                        }
                                    } else {
                                        convSum += fval * this.kernelData[kernelOffset + v];
                                        ++count;
                                    }
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                    } else {
                        hasResult = false;
                    }
                    if ((val = hasResult && count >= this.minKernelCells ? (int)convSum : nilValue) < 0) {
                        val = 0;
                    } else if (val > 255) {
                        val = 255;
                    }
                    destBandData[dstPixelOffset] = (byte)val;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void convolveAsShortData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        short[][] destData = destAcc.getShortDataArrays();
        short[][] srcData = srcAcc.getShortDataArrays();
        int nilValue = this.nilValueNumber.intValue();
        for (int k = 0; k < this.destBands; ++k) {
            int y = destAcc.getY();
            short[] destBandData = destData[k];
            short[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int x = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    int val = 0;
                    int count = 0;
                    float convSum = 0.5f;
                    boolean hasResult = true;
                    if (!this.maskDest || this.roi.contains(x, y)) {
                        int srcY = y - this.kernelKeyY;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (hasResult && u < this.kernelH) {
                            int srcX = x - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (hasResult && v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    float fval = srcBandData[imageOffset];
                                    if (this.isNoData(fval)) {
                                        if (this.strictNodata) {
                                            hasResult = false;
                                        }
                                    } else {
                                        convSum += fval * this.kernelData[kernelOffset + v];
                                        ++count;
                                    }
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                    } else {
                        hasResult = false;
                    }
                    if ((val = hasResult && count >= this.minKernelCells ? (int)convSum : nilValue) < Short.MIN_VALUE) {
                        val = Short.MIN_VALUE;
                    } else if (val > Short.MAX_VALUE) {
                        val = Short.MAX_VALUE;
                    }
                    destBandData[dstPixelOffset] = (short)val;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++x;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++y;
            }
        }
    }

    private void convolveAsUShortData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        short[][] destData = destAcc.getShortDataArrays();
        short[][] srcData = srcAcc.getShortDataArrays();
        int nilValue = this.nilValueNumber.intValue();
        for (int k = 0; k < this.destBands; ++k) {
            int y = destAcc.getY();
            short[] destBandData = destData[k];
            short[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int x = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    int val = 0;
                    int count = 0;
                    float convSum = 0.5f;
                    boolean hasResult = true;
                    if (!this.maskDest || this.roi.contains(x, y)) {
                        int srcY = y - this.kernelKeyY;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (hasResult && u < this.kernelH) {
                            int srcX = x - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (hasResult && v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    float fval = srcBandData[imageOffset] & 0xFFFF;
                                    if (this.isNoData(fval)) {
                                        if (this.strictNodata) {
                                            hasResult = false;
                                        }
                                    } else {
                                        convSum += fval * this.kernelData[kernelOffset + v];
                                        ++count;
                                    }
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                    } else {
                        hasResult = false;
                    }
                    if ((val = hasResult && count >= this.minKernelCells ? (int)convSum : nilValue) < 0) {
                        val = 0;
                    } else if (val > 65535) {
                        val = 65535;
                    }
                    destBandData[dstPixelOffset] = (short)val;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++x;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++y;
            }
        }
    }

    private void convolveAsIntData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        int[][] destData = destAcc.getIntDataArrays();
        int[][] srcData = srcAcc.getIntDataArrays();
        int nilValue = this.nilValueNumber.intValue();
        for (int k = 0; k < this.destBands; ++k) {
            int y = destAcc.getY();
            int[] destBandData = destData[k];
            int[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int x = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    float convSum = 0.5f;
                    int count = 0;
                    boolean hasResult = true;
                    if (!this.maskDest || this.roi.contains(x, y)) {
                        int srcY = y - this.kernelKeyY;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (hasResult && u < this.kernelH) {
                            int srcX = x - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (hasResult && v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    float fval = srcBandData[imageOffset];
                                    if (this.isNoData(fval)) {
                                        if (this.strictNodata) {
                                            hasResult = false;
                                        }
                                    } else {
                                        convSum += fval * this.kernelData[kernelOffset + v];
                                        ++count;
                                    }
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                    } else {
                        hasResult = false;
                    }
                    destBandData[dstPixelOffset] = hasResult && count >= this.minKernelCells ? (int)convSum : nilValue;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++x;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++y;
            }
        }
    }

    private void convolveAsFloatData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        float[][] destData = destAcc.getFloatDataArrays();
        float[][] srcData = srcAcc.getFloatDataArrays();
        float nilValue = this.nilValueNumber.floatValue();
        for (int k = 0; k < this.destBands; ++k) {
            int y = destAcc.getY();
            float[] destBandData = destData[k];
            float[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int x = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    float convSum = 0.0f;
                    int count = 0;
                    boolean hasResult = true;
                    if (!this.maskDest || this.roi.contains(x, y)) {
                        int srcY = y - this.kernelKeyY;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (hasResult && u < this.kernelH) {
                            int srcX = x - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (hasResult && v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    float fval = srcBandData[imageOffset];
                                    if (this.isNoData(fval)) {
                                        if (this.strictNodata) {
                                            hasResult = false;
                                        }
                                    } else {
                                        convSum += fval * this.kernelData[kernelOffset + v];
                                        ++count;
                                    }
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                    } else {
                        hasResult = false;
                    }
                    destBandData[dstPixelOffset] = hasResult && count >= this.minKernelCells ? convSum : nilValue;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++x;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++y;
            }
        }
    }

    private void convolveAsDoubleData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        double[][] destData = destAcc.getDoubleDataArrays();
        double[][] srcData = srcAcc.getDoubleDataArrays();
        double nilValue = this.nilValueNumber.doubleValue();
        for (int k = 0; k < this.destBands; ++k) {
            int y = destAcc.getY();
            double[] destBandData = destData[k];
            double[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int x = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    double convSum = 0.0;
                    int count = 0;
                    boolean hasResult = true;
                    if (!this.maskDest || this.roi.contains(x, y)) {
                        int srcY = y - this.kernelKeyY;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (hasResult && u < this.kernelH) {
                            int srcX = x - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (hasResult && v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    double dval = srcBandData[imageOffset];
                                    if (this.isNoData(dval)) {
                                        if (this.strictNodata) {
                                            hasResult = false;
                                        }
                                    } else {
                                        convSum += dval * (double)this.kernelData[kernelOffset + v];
                                        ++count;
                                    }
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                    } else {
                        hasResult = false;
                    }
                    destBandData[dstPixelOffset] = hasResult && count >= this.minKernelCells ? convSum : nilValue;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++x;
                }
                dstScanlineOffset += this.dstScanlineStride;
                srcScanlineOffset += this.srcScanlineStride;
                ++j;
                ++y;
            }
        }
    }
}

