/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.io.Serializable;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.LegacyEventMessage;

public class JGroupEventMessage
extends LegacyEventMessage {
    public static final int BOOTSTRAP_REQUEST = 10;
    public static final int BOOTSTRAP_RESPONSE = 11;
    public static final int BOOTSTRAP_COMPLETE = 12;
    public static final int BOOTSTRAP_INCOMPLETE = 13;
    private static final long serialVersionUID = 1L;
    private final String cacheName;
    private final long asyncTime;

    public JGroupEventMessage(int event, Serializable key, Element element, String cacheName) {
        super(event, key, element);
        this.cacheName = cacheName;
        this.asyncTime = -1L;
    }

    public JGroupEventMessage(int event, Serializable key, Element element, String cacheName, long asyncTime) {
        super(event, key, element);
        this.cacheName = cacheName;
        this.asyncTime = asyncTime;
    }

    public boolean isAsync() {
        return this.asyncTime >= 0L;
    }

    public long getAsyncTime() {
        return this.asyncTime;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String toString() {
        return "JGroupEventMessage [event=" + JGroupEventMessage.getEventName(this.getEvent()) + ", cacheName=" + this.cacheName + ", serializableKey=" + this.getSerializableKey() + ", element=" + this.getElement() + "]";
    }

    public static String getEventName(int event) {
        String eventName;
        switch (event) {
            case 0: {
                eventName = "PUT";
                break;
            }
            case 1: {
                eventName = "REMOVE";
                break;
            }
            case 3: {
                eventName = "REMOVE_ALL";
                break;
            }
            case 10: {
                eventName = "BOOTSTRAP_REQUEST";
                break;
            }
            case 11: {
                eventName = "BOOTSTRAP_RESPONSE";
                break;
            }
            case 12: {
                eventName = "BOOTSTRAP_COMPLETE";
                break;
            }
            case 13: {
                eventName = "BOOTSTRAP_INCOMPLETE";
                break;
            }
            default: {
                eventName = Integer.toString(event);
            }
        }
        return eventName;
    }
}

