/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups.jmx;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class AtomicRate {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final RateBucket[] rateBuckets;
    private final TimeUnit rateUnit;
    private final long rateDuration;
    private final long bucketDuration;
    private int newestBucket;

    public AtomicRate(int duration, TimeUnit unit) {
        int buckets = 10;
        this.newestBucket = 0;
        this.rateBuckets = new RateBucket[10];
        this.rateBuckets[this.newestBucket] = new RateBucket();
        this.rateUnit = unit;
        this.rateDuration = this.rateUnit.toNanos(duration);
        this.bucketDuration = this.rateDuration / 10L;
    }

    public TimeUnit getRateUnit() {
        return this.rateUnit;
    }

    public long getRateDuration() {
        return this.rateUnit.convert(this.rateDuration, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void count() {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            RateBucket rateBucket = this.rateBuckets[this.newestBucket];
            if (rateBucket.start + this.bucketDuration < System.nanoTime()) {
                readLock.unlock();
                Lock writeLock = this.readWriteLock.writeLock();
                writeLock.lock();
                try {
                    rateBucket = this.rateBuckets[this.newestBucket];
                    if (rateBucket.start + this.bucketDuration < System.nanoTime()) {
                        rateBucket = new RateBucket();
                        this.newestBucket = (this.newestBucket + 1) % this.rateBuckets.length;
                        this.rateBuckets[this.newestBucket] = rateBucket;
                    }
                }
                finally {
                    writeLock.unlock();
                    readLock.lock();
                }
            }
            rateBucket.count.incrementAndGet();
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRate() {
        long now = System.nanoTime();
        int count = 0;
        long duration = 0L;
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            RateBucket bucket;
            int bucketIndex = this.newestBucket;
            while ((bucket = this.rateBuckets[bucketIndex]) != null) {
                if (bucket.start + this.rateDuration < now) {
                    break;
                }
                count += bucket.count.get();
                duration += Math.min(this.bucketDuration, now - bucket.start);
                if (--bucketIndex >= 0) continue;
                bucketIndex = this.rateBuckets.length - 1;
            }
        }
        finally {
            readLock.unlock();
        }
        if (duration == 0L) {
            return Double.NaN;
        }
        return (double)count / (double)duration * (double)this.rateUnit.toNanos(1L);
    }

    private static final class RateBucket {
        private final long start = System.nanoTime();
        private final AtomicInteger count = new AtomicInteger();

        private RateBucket() {
        }

        public String toString() {
            return "RateBucket [start=" + this.start + ", count=" + this.count + "]";
        }
    }
}

