/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.util.Properties;
import net.sf.ehcache.bootstrap.BootstrapCacheLoaderFactory;
import net.sf.ehcache.distribution.jgroups.JGroupsBootstrapCacheLoader;
import net.sf.ehcache.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsBootstrapCacheLoaderFactory
extends BootstrapCacheLoaderFactory<JGroupsBootstrapCacheLoader> {
    public static final String BOOTSTRAP_ASYNCHRONOUSLY = "bootstrapAsynchronously";
    public static final String MAXIMUM_CHUNK_SIZE_BYTES = "maximumChunkSizeBytes";
    protected static final int DEFAULT_MAXIMUM_CHUNK_SIZE_BYTES = 5000000;
    protected static final int ONE_HUNDRED_MB = 100000000;
    protected static final int FIVE_KB = 5000;
    private static final Logger LOG = LoggerFactory.getLogger((String)JGroupsBootstrapCacheLoaderFactory.class.getName());

    public JGroupsBootstrapCacheLoader createBootstrapCacheLoader(Properties properties) {
        if (properties == null) {
            LOG.debug("Creating JGroups BootstrapCacheLoader with default configuration.");
        } else {
            LOG.debug("Creating JGroups BootstrapCacheLoader with configuration:\n{}", (Object)properties);
        }
        boolean bootstrapAsynchronously = this.extractAndValidateBootstrapAsynchronously(properties);
        int maximumChunkSizeBytes = this.extractMaximumChunkSizeBytes(properties);
        return new JGroupsBootstrapCacheLoader(bootstrapAsynchronously, maximumChunkSizeBytes);
    }

    protected int extractMaximumChunkSizeBytes(Properties properties) {
        int maximumChunkSizeBytesCandidate;
        int maximumChunkSizeBytes = 0;
        String maximumChunkSizeBytesString = PropertyUtil.extractAndLogProperty((String)MAXIMUM_CHUNK_SIZE_BYTES, (Properties)properties);
        if (maximumChunkSizeBytesString == null) {
            return 5000000;
        }
        try {
            maximumChunkSizeBytesCandidate = Integer.parseInt(maximumChunkSizeBytesString);
        }
        catch (NumberFormatException e) {
            LOG.warn("Number format exception trying to set chunk size to '{}'. Using the default instead.", (Object)maximumChunkSizeBytesString);
            return 5000000;
        }
        if (maximumChunkSizeBytesCandidate < 5000 || maximumChunkSizeBytesCandidate > 100000000) {
            LOG.warn("Trying to set the chunk size to an unreasonable number: {}. Using the default instead.", (Object)maximumChunkSizeBytesCandidate);
            return 5000000;
        }
        return maximumChunkSizeBytes;
    }

    protected boolean extractAndValidateBootstrapAsynchronously(Properties properties) {
        String bootstrapAsynchronouslyString = PropertyUtil.extractAndLogProperty((String)BOOTSTRAP_ASYNCHRONOUSLY, (Properties)properties);
        if (bootstrapAsynchronouslyString != null) {
            return Boolean.parseBoolean(bootstrapAsynchronouslyString);
        }
        return true;
    }
}

