/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.jgroups.JGroupsBootstrapManager;
import net.sf.ehcache.distribution.jgroups.JGroupsCachePeer;
import net.sf.ehcache.distribution.jgroups.JGroupsCacheReceiver;
import net.sf.ehcache.management.ManagedCacheManagerPeerProvider;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.jmx.JmxConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsCacheManagerPeerProvider
implements ManagedCacheManagerPeerProvider {
    public static final String SCHEME_NAME = "JGroups";
    private static final String JMX_DOMAIN_NAME = "JGroupsReplication";
    private static final Logger LOG = LoggerFactory.getLogger((String)JGroupsCacheManagerPeerProvider.class.getName());
    private final CacheManager cacheManager;
    private final String groupProperties;
    private final URL groupUrl;
    private String channelName;
    private JChannel channel;
    private JGroupsCachePeer cachePeer;
    private JGroupsCacheReceiver cacheReceiver;
    private List<CachePeer> cachePeersListCache;
    private JGroupsBootstrapManager bootstrapManager;
    private MBeanServer mBeanServer;

    public JGroupsCacheManagerPeerProvider(CacheManager cacheManager, String properties) {
        this.cacheManager = cacheManager;
        this.groupProperties = properties;
        this.groupUrl = null;
    }

    public JGroupsCacheManagerPeerProvider(CacheManager cacheManager, URL configUrl) {
        this.cacheManager = cacheManager;
        this.groupProperties = null;
        this.groupUrl = configUrl;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public static JGroupsCacheManagerPeerProvider getCachePeerProvider(Ehcache cache) {
        CacheManager cacheManager = cache.getCacheManager();
        return JGroupsCacheManagerPeerProvider.getCachePeerProvider(cacheManager);
    }

    public static JGroupsCacheManagerPeerProvider getCachePeerProvider(CacheManager cacheManager) {
        CacheManagerPeerProvider provider = cacheManager.getCacheManagerPeerProvider(SCHEME_NAME);
        if (provider == null) {
            LOG.warn("No CacheManagerPeerProvider registered for {} scheme.", (Object)SCHEME_NAME);
            return null;
        }
        if (!(provider instanceof JGroupsCacheManagerPeerProvider)) {
            LOG.warn("{} for scheme {} cannot be cast to {}.", new Object[]{provider.getClass(), SCHEME_NAME, JGroupsCacheManagerPeerProvider.class});
            return null;
        }
        return (JGroupsCacheManagerPeerProvider)provider;
    }

    public void init() {
        try {
            this.channel = this.groupProperties != null ? new JChannel(this.groupProperties) : (this.groupUrl != null ? new JChannel(this.groupUrl) : new JChannel());
        }
        catch (Exception e) {
            LOG.error("Failed to create JGroups Channel, replication will not function. JGroups properties:\n" + this.groupProperties, (Throwable)e);
            this.dispose();
            return;
        }
        String clusterName = this.getClusterName();
        this.cachePeer = new JGroupsCachePeer((Channel)this.channel, clusterName);
        this.bootstrapManager = new JGroupsBootstrapManager(clusterName, this.cachePeer, this.cacheManager);
        this.cacheReceiver = new JGroupsCacheReceiver(this.cacheManager, this.bootstrapManager);
        this.channel.setReceiver((Receiver)this.cacheReceiver);
        try {
            this.channel.connect(clusterName);
        }
        catch (Exception e) {
            LOG.error("Failed to connect to JGroups cluster '" + clusterName + "', replication will not function. JGroups properties:\n" + this.groupProperties, (Throwable)e);
            this.dispose();
            return;
        }
        this.cachePeersListCache = Collections.singletonList(this.cachePeer);
        LOG.info("JGroups Replication started for '" + clusterName + "'. JChannel: {}", (Object)this.channel.toString(true));
    }

    public void register(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
        try {
            String clusterName = this.getClusterName();
            JmxConfigurator.registerChannel((JChannel)this.channel, (MBeanServer)mBeanServer, (String)JMX_DOMAIN_NAME, (String)clusterName, (boolean)true);
            LOG.debug("Registered JGroups channel with MBeanServer under domain {} with name {}", (Object)JMX_DOMAIN_NAME, (Object)clusterName);
        }
        catch (Exception e) {
            LOG.error("Error occured while registering MBeans. Management of JGroups will not be enabled.", (Throwable)e);
        }
    }

    public void dispose() throws CacheException {
        if (this.bootstrapManager != null) {
            this.bootstrapManager.dispose();
            this.bootstrapManager = null;
        }
        this.shutdownCachePeer();
        this.shutdownChannel();
    }

    private void shutdownCachePeer() {
        if (this.cachePeer != null) {
            this.cachePeersListCache = null;
            this.cacheReceiver = null;
            this.cachePeer.dispose();
            this.cachePeer = null;
        }
    }

    private void shutdownChannel() {
        if (this.channel != null) {
            String clusterName = this.getClusterName();
            if (this.mBeanServer != null) {
                try {
                    JmxConfigurator.unregisterChannel((JChannel)this.channel, (MBeanServer)this.mBeanServer, (String)JMX_DOMAIN_NAME, (String)clusterName);
                    LOG.debug("Unregistered JGroups channel with MBeanServer under domain {} with name {}", (Object)JMX_DOMAIN_NAME, (Object)clusterName);
                }
                catch (Exception e) {
                    LOG.error("Error unregistering JGroups channel with MBeanServer under domain JGroupsReplication with name " + clusterName, (Throwable)e);
                }
            }
            if (this.channel.isConnected()) {
                try {
                    this.channel.close();
                    LOG.debug("Closing JChannel for cluster {}", (Object)clusterName);
                }
                catch (Exception e) {
                    LOG.error("Error closing JChannel for cluster " + clusterName, (Throwable)e);
                }
            }
            this.channel = null;
        }
    }

    public long getTimeForClusterToForm() {
        return 0L;
    }

    public String getScheme() {
        return SCHEME_NAME;
    }

    public List<CachePeer> listRemoteCachePeers(Ehcache cache) throws CacheException {
        if (this.cachePeersListCache == null) {
            return Collections.emptyList();
        }
        return this.cachePeersListCache;
    }

    public void registerPeer(String rmiUrl) {
    }

    public void unregisterPeer(String rmiUrl) {
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public JGroupsBootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }

    public Status getStatus() {
        if (this.channel == null) {
            return Status.STATUS_UNINITIALISED;
        }
        if (!this.channel.isConnected()) {
            return Status.STATUS_SHUTDOWN;
        }
        return Status.STATUS_ALIVE;
    }

    public String getClusterName() {
        if (this.channelName != null) {
            return this.channelName;
        }
        if (this.cacheManager.isNamed()) {
            return this.cacheManager.getName();
        }
        return "EH_CACHE";
    }
}

