/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;
import org.jasig.services.persondir.support.merger.IAttributeMerger;
import org.jasig.services.persondir.support.merger.MultivaluedAttributeMerger;

public abstract class AbstractAggregatingDefaultQueryPersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    protected List personAttributeDaos;
    protected IAttributeMerger attrMerger = new MultivaluedAttributeMerger();
    protected boolean recoverExceptions = true;

    public final Map getUserAttributes(Map seed) {
        if (seed == null) {
            throw new IllegalArgumentException("The query seed Map cannot be null.");
        }
        if (this.personAttributeDaos == null) {
            throw new IllegalStateException("No IPersonAttributeDaos have been specified.");
        }
        Map resultAttributes = null;
        boolean isFirstQuery = true;
        Iterator iter = this.personAttributeDaos.iterator();
        while (iter.hasNext()) {
            IPersonAttributeDao currentlyConsidering = (IPersonAttributeDao)iter.next();
            Map currentAttributes = new HashMap();
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Getting attributes for seed='" + seed + "', isFirstQuery=" + isFirstQuery + ", currentlyConsidering='" + currentlyConsidering + "', resultAttributes='" + resultAttributes + "'"));
                }
                currentAttributes = this.getAttributesFromDao(seed, isFirstQuery, currentlyConsidering, resultAttributes);
                isFirstQuery = false;
            }
            catch (RuntimeException rte) {
                if (this.recoverExceptions) {
                    this.logger.warn((Object)("Recovering From Exception thrown by '" + currentlyConsidering + "'"), (Throwable)rte);
                }
                this.logger.error((Object)("Failing From Exception thrown by '" + currentlyConsidering + "'"), (Throwable)rte);
                throw rte;
            }
            if (resultAttributes == null) {
                resultAttributes = currentAttributes;
                continue;
            }
            if (currentAttributes == null) continue;
            resultAttributes = this.attrMerger.mergeAttributes(resultAttributes, currentAttributes);
        }
        return resultAttributes;
    }

    protected abstract Map getAttributesFromDao(Map var1, boolean var2, IPersonAttributeDao var3, Map var4);

    public Set getPossibleUserAttributeNames() {
        HashSet attrNames = new HashSet();
        Iterator iter = this.personAttributeDaos.iterator();
        while (iter.hasNext()) {
            IPersonAttributeDao currentDao = (IPersonAttributeDao)iter.next();
            Set currentDaoAttrNames = null;
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Getting possible attribute names from '" + currentDao + "'"));
                }
                currentDaoAttrNames = currentDao.getPossibleUserAttributeNames();
            }
            catch (RuntimeException rte) {
                if (this.recoverExceptions) {
                    this.logger.warn((Object)("Recovering From Exception thrown by '" + currentDao + "'"), (Throwable)rte);
                }
                this.logger.error((Object)("Failing From Exception thrown by '" + currentDao + "'"), (Throwable)rte);
                throw rte;
            }
            if (currentDaoAttrNames == null) continue;
            attrNames.addAll(currentDaoAttrNames);
        }
        return Collections.unmodifiableSet(attrNames);
    }

    public IAttributeMerger getMerger() {
        return this.attrMerger;
    }

    public void setMerger(IAttributeMerger merger) {
        if (merger == null) {
            throw new IllegalArgumentException("The merger cannot be null");
        }
        this.attrMerger = merger;
    }

    public List getPersonAttributeDaos() {
        return this.personAttributeDaos;
    }

    public void setPersonAttributeDaos(List daos) {
        if (daos == null) {
            throw new IllegalArgumentException("The dao list cannot be null");
        }
        this.personAttributeDaos = Collections.unmodifiableList(daos);
    }

    public boolean isRecoverExceptions() {
        return this.recoverExceptions;
    }

    public void setRecoverExceptions(boolean recover) {
        this.recoverExceptions = recover;
    }
}

