/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.ldap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.jasig.services.persondir.support.AbstractQueryPersonAttributeDao;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.jasig.services.persondir.support.ldap.PersonAttributesMapper;
import org.jasig.services.persondir.support.ldap.QuerySearchExecutor;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.ldap.AttributesMapper;
import org.springframework.ldap.ContextSource;
import org.springframework.ldap.LdapTemplate;
import org.springframework.ldap.NameClassPairCallbackHandler;
import org.springframework.ldap.SearchExecutor;

public class LdapPersonAttributeDao
extends AbstractQueryPersonAttributeDao {
    private int timeLimit = 0;
    private String query;
    private PersonAttributesMapper attributesMapper = new PersonAttributesMapper(Collections.EMPTY_MAP);
    private Set possibleUserAttributeNames = Collections.EMPTY_SET;
    private String baseDN = "";
    private ContextSource contextSource = null;
    private LdapTemplate ldapTemplate = null;
    private final SearchControls searchControls = new SearchControls();

    public LdapPersonAttributeDao() {
        this.searchControls.setSearchScope(2);
    }

    protected Map getUserAttributesIfNeeded(Object[] args) {
        if (this.contextSource == null) {
            throw new IllegalStateException("ContextSource is null");
        }
        if (this.query == null) {
            throw new IllegalStateException("query is null");
        }
        QuerySearchExecutor se = new QuerySearchExecutor(this.baseDN, this.query, args, this.searchControls);
        LdapTemplate ldapTemplate = this.ldapTemplate;
        ldapTemplate.getClass();
        LdapTemplate.AttributesMapperCallbackHandler attributesMapperCallbackHandler = new LdapTemplate.AttributesMapperCallbackHandler(ldapTemplate, (AttributesMapper)this.attributesMapper);
        this.ldapTemplate.search((SearchExecutor)se, (NameClassPairCallbackHandler)attributesMapperCallbackHandler);
        List results = attributesMapperCallbackHandler.getList();
        return (Map)DataAccessUtils.uniqueResult((Collection)results);
    }

    public Set getPossibleUserAttributeNames() {
        return this.possibleUserAttributeNames;
    }

    public Map getLdapAttributesToPortalAttributes() {
        return this.attributesMapper.getLdapAttributesToPortalAttributes();
    }

    public void setLdapAttributesToPortalAttributes(Map ldapAttributesToPortalAttributesArg) {
        Map ldapAttributesToPortalAttributes = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(ldapAttributesToPortalAttributesArg);
        this.attributesMapper = new PersonAttributesMapper(ldapAttributesToPortalAttributes);
        Collection userAttributeCol = MultivaluedPersonAttributeUtils.flattenCollection(ldapAttributesToPortalAttributes.values());
        this.possibleUserAttributeNames = Collections.unmodifiableSet(new HashSet(userAttributeCol));
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
        this.searchControls.setTimeLimit(this.timeLimit);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String uidQuery) {
        this.query = uidQuery;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        if (baseDN == null) {
            baseDN = "";
        }
        this.baseDN = baseDN;
    }

    public ContextSource getContextSource() {
        return this.contextSource;
    }

    public void setContextSource(ContextSource contextSource) {
        this.contextSource = contextSource;
        this.ldapTemplate = new LdapTemplate(this.contextSource);
    }
}

