/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;
import org.jasig.services.persondir.support.rule.AttributeRule;

public final class DeclaredRulePersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    private List rules;

    public DeclaredRulePersonAttributeDao(String attributeName, List rules) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating DeclaredRulePersonAttributeDao with attributeName='" + attributeName + "' and rules='" + rules + "'"));
        }
        this.setDefaultAttributeName(attributeName);
        this.setRules(rules);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created DeclaredRulePersonAttributeDao with attributeName='" + attributeName + "' and rules='" + rules + "'"));
        }
    }

    public List getRules() {
        return this.rules;
    }

    public void setRules(List rules) {
        if (rules == null) {
            throw new IllegalArgumentException("Argument 'rules' cannot be null.");
        }
        if (rules.size() < 1) {
            throw new IllegalArgumentException("Argument 'rules' must contain at least one element.");
        }
        this.rules = Collections.unmodifiableList(new ArrayList(rules));
    }

    public Map getUserAttributes(Map seed) {
        if (seed == null) {
            throw new IllegalArgumentException("Argument 'seed' cannot be null.");
        }
        if (this.rules == null) {
            throw new IllegalStateException("rules array cannot be null.");
        }
        if (this.rules.size() < 1) {
            throw new IllegalStateException("rules array must contain at least one element.");
        }
        Map rslt = null;
        Iterator rulesItr = this.rules.iterator();
        while (rulesItr.hasNext()) {
            AttributeRule r = (AttributeRule)rulesItr.next();
            if (!r.appliesTo(seed)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Evaluating rule='" + r + "' from the rules List"));
            }
            rslt = r.evaluate(seed);
            break;
        }
        return rslt;
    }

    public Set getPossibleUserAttributeNames() {
        TreeSet rslt = new TreeSet();
        Iterator rulesItr = this.rules.iterator();
        while (rulesItr.hasNext()) {
            AttributeRule r = (AttributeRule)rulesItr.next();
            rslt.addAll(r.getPossibleUserAttributeNames());
        }
        return rslt;
    }
}

