/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.controller;

import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.UnauthorizedException;
import org.jasig.portlet.announcements.controller.AdminController;
import org.jasig.portlet.announcements.controller.TopicEditor;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.validators.AnnouncementValidator;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.support.SessionStatus;

@Controller
@RequestMapping(value={"VIEW"})
public class AdminAnnouncementController
implements InitializingBean {
    public static final String PREFERENCE_ALLOW_OPEN_ENDDATE = "AdminAnnouncementController.allowOpenEndDate";
    @Autowired
    private IAnnouncementService announcementService;
    private static final Log log = LogFactory.getLog(AdminController.class);
    private PropertyEditor topicEditor;
    @Autowired
    private String customDateFormat = "yyyy-MM-dd";
    private String datePickerFormat = "format-y-m-d divider-dash";

    @InitBinder(value={"announcement"})
    public void initBinder(WebDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.customDateFormat);
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
        binder.registerCustomEditor(Topic.class, this.topicEditor);
        binder.setAllowedFields(new String[]{"id", "created", "author", "title", "abstractText", "message", "link", "startDisplay", "endDisplay", "parent", "action"});
    }

    @RequestMapping(params={"action=addAnnouncement"})
    public String showAddAnnouncementForm(@RequestParam(value="editId", required=false) Long editId, @RequestParam(value="topicId", required=false) Long topicId, Model model) throws PortletException {
        if (!model.containsAttribute("announcement")) {
            Announcement ann = new Announcement();
            Topic topic = null;
            if (editId != null) {
                try {
                    log.debug((Object)("editId found. This is an edit request for announcement Id " + editId.toString()));
                    ann = this.announcementService.getAnnouncement(editId);
                }
                catch (NumberFormatException e) {
                    log.debug((Object)"No editId found. This is not an edit request");
                }
            }
            if (ann != null && ann.getParent() == null) {
                try {
                    topic = this.announcementService.getTopic(topicId);
                    ann.setParent(topic);
                }
                catch (NumberFormatException e) {
                    log.error((Object)"Unable to get topicId from request");
                }
            }
            model.addAttribute("announcement", (Object)ann);
        }
        model.addAttribute("datePickerFormat", (Object)this.datePickerFormat);
        return "addAnnouncement";
    }

    @RequestMapping(params={"action=addAnnouncement"})
    public void actionAddAnnouncementForm(ActionRequest request, ActionResponse response, @ModelAttribute(value="announcement") Announcement announcement, BindingResult result, SessionStatus status) throws PortletException {
        new AnnouncementValidator(this.getAllowOpenEndDate((PortletRequest)request)).validate(announcement, (Errors)result);
        if (result.hasErrors()) {
            response.setRenderParameter("action", "addAnnouncement");
            return;
        }
        if (!result.hasErrors()) {
            if (!announcement.hasId()) {
                announcement.setAuthor(request.getRemoteUser());
                announcement.setCreated(new Date());
                this.announcementService.addOrSaveAnnouncement(announcement);
            } else {
                this.announcementService.mergeAnnouncement(announcement);
            }
            status.setComplete();
            response.setRenderParameter("topicId", announcement.getParent().getId().toString());
            response.setRenderParameter("action", "showTopic");
        }
    }

    @RequestMapping(params={"action=deleteAnnouncement"})
    public void actionDeleteAnnouncement(@RequestParam(value="topicId") Long topicId, @RequestParam(value="annId") Long annId, ActionRequest request, ActionResponse response) throws PortletException {
        Topic topic = this.announcementService.getTopic(topicId);
        Announcement ann = this.announcementService.getAnnouncement(annId);
        if (!(UserPermissionChecker.inRoleForTopic((PortletRequest)request, "moderators", topic) || UserPermissionChecker.inRoleForTopic((PortletRequest)request, "admins", topic) || UserPermissionChecker.inRoleForTopic((PortletRequest)request, "authors", topic) && ann.getAuthor() == request.getRemoteUser())) {
            throw new UnauthorizedException("You do not have access to this topic!");
        }
        this.announcementService.deleteAnnouncement(ann);
        response.setRenderParameter("topicId", topicId.toString());
        response.setRenderParameter("action", "showTopic");
    }

    public boolean getAllowOpenEndDate(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        return Boolean.parseBoolean(prefs.getValue(PREFERENCE_ALLOW_OPEN_ENDDATE, "false"));
    }

    public void setCustomDateFormat(String customDateFormat) {
        this.customDateFormat = customDateFormat;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to parse custom date input format: [" + customDateFormat + "]"));
        }
        String[] finalPieces = new String[]{"", "", ""};
        String[] pieces = new String[]{"", "", ""};
        String divider = null;
        if (customDateFormat.contains("/") && !customDateFormat.contains("-") && !customDateFormat.contains(".")) {
            pieces = customDateFormat.split("/");
            divider = "slash";
        } else if (customDateFormat.contains("-") && !customDateFormat.contains("/") && !customDateFormat.contains(".")) {
            pieces = customDateFormat.split("-");
            divider = "dash";
        } else if (customDateFormat.contains(".") && !customDateFormat.contains("/") && !customDateFormat.contains("-")) {
            pieces = customDateFormat.split("\\.");
            divider = "dot";
        } else {
            return;
        }
        if (pieces.length > 3) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Custom date input format: [" + pieces[0] + " " + divider + " " + pieces[1] + " " + divider + " " + pieces[2] + "]"));
        }
        for (int i = 0; i < pieces.length; ++i) {
            if (pieces[i].equalsIgnoreCase("mm")) {
                finalPieces[i] = "m";
                continue;
            }
            if (pieces[i].equalsIgnoreCase("dd")) {
                finalPieces[i] = "d";
                continue;
            }
            if (!pieces[i].equalsIgnoreCase("yyyy")) continue;
            finalPieces[i] = "y";
        }
        this.datePickerFormat = "format-" + finalPieces[0] + "-" + finalPieces[1] + "-" + finalPieces[2] + " divider-" + divider;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Custom date input format parsed as: [" + this.datePickerFormat + "]"));
        }
    }

    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    public void afterPropertiesSet() throws Exception {
        this.topicEditor = new TopicEditor(this.announcementService);
    }
}

