/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.UnauthorizedException;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.validators.TopicValidator;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.support.SessionStatus;

@Controller
@RequestMapping(value={"VIEW"})
public class AdminTopicController {
    private static final Log log = LogFactory.getLog(AdminTopicController.class);
    @Autowired
    private IAnnouncementService announcementService;
    @Autowired
    private Boolean includeJQuery;

    @RequestMapping(params={"action=addTopic"})
    public String showAddTopicForm(@RequestParam(value="edit", required=false) String topicIdStr, Model model) throws PortletException {
        if (!model.containsAttribute("topic")) {
            if (topicIdStr != null && !"".equals(topicIdStr)) {
                Long topicId = Long.parseLong(topicIdStr);
                Topic t = this.announcementService.getTopic(topicId);
                model.addAttribute("topic", (Object)t);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding existing topic to model: " + t.toString()));
                }
            } else {
                model.addAttribute("topic", (Object)new Topic());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Adding new topic to model");
                }
            }
        }
        return "addTopic";
    }

    @RequestMapping(params={"action=addTopic"})
    public void actionAddTopicForm(@ModelAttribute(value="topic") Topic topic, BindingResult result, SessionStatus status, ActionRequest request, ActionResponse response) throws PortletException {
        new TopicValidator().validate(topic, (Errors)result);
        if (result.hasErrors()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error in form: " + result.toString()));
            }
            response.setRenderParameter("action", "addTopic");
            return;
        }
        if (!result.hasErrors() && topic != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No errors in form");
            }
            if (!topic.hasId()) {
                topic.setCreator(request.getRemoteUser());
            } else {
                Long id = topic.getId();
                Topic oldTopic = this.announcementService.getTopic(id);
                topic.setCreator(oldTopic.getCreator());
                topic.setAdmins(oldTopic.getAdmins());
                topic.setAudience(oldTopic.getAudience());
                topic.setModerators(oldTopic.getModerators());
                topic.setAuthors(oldTopic.getAuthors());
            }
            this.announcementService.addOrSaveTopic(topic);
            status.setComplete();
            response.setRenderParameter("action", "baseAdmin");
        }
    }

    @RequestMapping(params={"action=deleteTopic"})
    public void actionDeleteTopic(@RequestParam(value="topicId") String topicId, ActionRequest request, ActionResponse response) throws NumberFormatException, PortletException {
        Topic topic = this.announcementService.getTopic(Long.parseLong(topicId));
        if (!UserPermissionChecker.inRoleForTopic((PortletRequest)request, "admins", topic)) {
            throw new UnauthorizedException("You do not have access to delete this topic!");
        }
        this.announcementService.deleteTopic(topic);
        response.setRenderParameter("action", "baseAdmin");
    }

    @RequestMapping(params={"action=showTopic"})
    public String showTopic(@RequestParam(value="topicId") String topicId, RenderRequest request, Model model) throws NumberFormatException, PortletException {
        Topic topic = this.announcementService.getTopic(Long.parseLong(topicId));
        if (!(UserPermissionChecker.inRoleForTopic((PortletRequest)request, "authors", topic) || UserPermissionChecker.inRoleForTopic((PortletRequest)request, "moderators", topic) || UserPermissionChecker.inRoleForTopic((PortletRequest)request, "admins", topic))) {
            throw new UnauthorizedException("You do not have access to this topic!");
        }
        Set<Announcement> annSet = topic.getAnnouncements();
        ArrayList<Announcement> annList = new ArrayList<Announcement>();
        annList.addAll(annSet);
        if (annSet.size() < 1) {
            annList = null;
        }
        if (annList != null) {
            Collections.sort(annList);
        }
        model.addAttribute("user", (Object)new UserPermissionChecker((PortletRequest)request, topic));
        model.addAttribute("topic", (Object)topic);
        model.addAttribute("announcements", annList);
        model.addAttribute("now", (Object)new Date());
        model.addAttribute("includeJQuery", (Object)this.includeJQuery);
        return "showTopic";
    }

    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    public void setIncludeJQuery(Boolean includeJQuery) {
        this.includeJQuery = includeJQuery;
    }
}

