/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.TopicSubscription;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.ITopicSubscriptionService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;

public class UserConfiguredTopicSubscriptionService
implements ITopicSubscriptionService {
    private Log log = LogFactory.getLog(this.getClass());
    private IAnnouncementService announcementService;
    private Topic emergencyTopic;

    public void init() {
        Topic t = null;
        try {
            t = this.announcementService.getEmergencyTopic();
        }
        catch (Exception ex) {
            this.log.error((Object)("Could not load emergencyTopic from database: " + ex.getMessage()));
        }
        if (t == null && this.emergencyTopic != null) {
            this.announcementService.addOrSaveTopic(this.emergencyTopic);
        } else {
            this.emergencyTopic = t;
        }
    }

    @Override
    public List<TopicSubscription> getTopicSubscription(RenderRequest request, boolean includeEmergency) throws PortletException {
        ArrayList<TopicSubscription> subscriptions = new ArrayList<TopicSubscription>();
        List<Object> subSaved = null;
        List<Topic> allTopics = this.announcementService.getAllTopics();
        if (request.getRemoteUser() == null) {
            subSaved = new ArrayList();
        } else {
            try {
                subSaved = this.announcementService.getTopicSubscriptionFor(request);
            }
            catch (Exception e) {
                this.log.error((Object)("ERROR getting topic subscriptions for " + request.getRemoteUser() + ": " + e.getMessage()));
            }
        }
        String user = request.getRemoteUser();
        if (user == null) {
            user = "guest";
        }
        if (subSaved != null) {
            this.log.debug((Object)("Found DisplayPrefs for " + user));
            for (Topic topic : allTopics) {
                boolean allowedToViewTopic = false;
                allowedToViewTopic = UserPermissionChecker.inRoleForTopic((PortletRequest)request, "audience", topic);
                if (allowedToViewTopic && topic.getSubscriptionMethod() == 1) {
                    TopicSubscription invalid = null;
                    for (TopicSubscription topicSubscription : subSaved) {
                        if (!topicSubscription.getTopic().equals(topic) || !topicSubscription.getSubscribed().equals(Boolean.FALSE)) continue;
                        invalid = topicSubscription;
                    }
                    if (invalid != null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Removing invalid TopicSubscription topic [" + topic.getId() + "] for " + user));
                        }
                        subSaved.remove(invalid);
                        this.announcementService.deleteTopicSubscription(invalid);
                    }
                    if (!this.topicSubscriptionExists(topic, subSaved)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Adding missing PUSHED_FORCED topic [" + topic.getId() + "] for " + user));
                        }
                        subscriptions.add(new TopicSubscription(user, topic, new Boolean(true)));
                    }
                } else if (allowedToViewTopic && topic.getSubscriptionMethod() == 2 && !this.topicSubscriptionExists(topic, subSaved)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Adding missing PUSHED_INITIAL topic [" + topic.getId() + "] for " + user));
                    }
                    subscriptions.add(new TopicSubscription(user, topic, new Boolean(true)));
                } else if (allowedToViewTopic && topic.getSubscriptionMethod() == 3 && !this.topicSubscriptionExists(topic, subSaved)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Adding missing PULLED topic [" + topic.getId() + "] for " + user));
                    }
                    subscriptions.add(new TopicSubscription(user, topic, new Boolean(false)));
                }
                if (allowedToViewTopic || !this.topicSubscriptionExists(topic, subSaved)) continue;
                TopicSubscription toRemove = null;
                for (TopicSubscription topicSubscription : subSaved) {
                    if (!topicSubscription.getTopic().equals(topic)) continue;
                    toRemove = topicSubscription;
                }
                if (toRemove == null) continue;
                subSaved.remove(toRemove);
                this.announcementService.deleteTopicSubscription(toRemove);
            }
            subscriptions.addAll(subSaved);
            if (includeEmergency) {
                this.emergencyTopic = this.announcementService.getEmergencyTopic();
                subscriptions.add(new TopicSubscription(user, this.emergencyTopic, new Boolean(true)));
            }
            return subscriptions;
        }
        throw new PortletException("Could not determine/create subscription preferences for user " + user);
    }

    @Override
    public List<TopicSubscription> getTopicSubscriptionEdit(RenderRequest request) throws PortletException {
        return this.getTopicSubscription(request, false);
    }

    @Override
    public List<TopicSubscription> getTopicSubscription(RenderRequest request) throws PortletException {
        return this.getTopicSubscription(request, true);
    }

    private boolean topicSubscriptionExists(Topic topic, List<TopicSubscription> subscriptions) {
        for (TopicSubscription ts : subscriptions) {
            if (ts.getTopic().getId().compareTo(topic.getId()) == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Topic [" + topic.getId() + ": " + topic.getTitle() + "] was found in TopicSubscription [Topic: " + ts.getTopic().getId() + " " + ts.getTopic().getTitle() + "] for " + ts.getOwner()));
                }
                return true;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Topic [" + topic.getId() + ": " + topic.getTitle() + "] is not referenced in TopicSubscription [Topic: " + ts.getTopic().getId() + " " + ts.getTopic().getTitle() + "] for " + ts.getOwner()));
        }
        return false;
    }

    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    public void setEmergencyTopic(Topic emergencyTopic) {
        this.emergencyTopic = emergencyTopic;
        this.log.debug((Object)"Emergency Topic assigned successfully.");
    }
}

