/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.util.Set;
import javax.portlet.PortletRequest;
import org.jasig.portlet.announcements.model.Topic;

public class UserPermissionChecker {
    public boolean admin;
    public boolean moderator;
    public boolean author;
    public boolean audience;
    public String userName;
    private static final String ADMIN_ROLE_NAME = "Portal_Administrators";

    public UserPermissionChecker(PortletRequest request, Topic topic) {
        String user = request.getRemoteUser();
        if (user == null) {
            user = "guest";
        }
        this.admin = UserPermissionChecker.inRoleForTopic(request, "admins", topic);
        this.moderator = UserPermissionChecker.inRoleForTopic(request, "moderators", topic);
        this.author = UserPermissionChecker.inRoleForTopic(request, "authors", topic);
        this.audience = UserPermissionChecker.inRoleForTopic(request, "audience", topic);
        this.userName = user;
        if (request.isUserInRole(ADMIN_ROLE_NAME)) {
            this.admin = true;
        }
        if (this.admin) {
            this.moderator = true;
        }
        if (this.moderator) {
            this.author = true;
        }
    }

    public static boolean isPortalAdmin(PortletRequest request) {
        return request.isUserInRole(ADMIN_ROLE_NAME);
    }

    public static boolean inRoleForTopic(PortletRequest request, String role, Topic topic) {
        boolean isGuest;
        boolean bl = isGuest = request.getRemoteUser() == null;
        if (!isGuest && UserPermissionChecker.isPortalAdmin(request)) {
            return true;
        }
        String user = request.getRemoteUser();
        if (isGuest) {
            user = "guest";
        }
        Set<String> group = topic.getGroup(role);
        for (String groupMember : group) {
            String[] p;
            if (request.isUserInRole(groupMember)) {
                return true;
            }
            if (!groupMember.startsWith("USER.") || !(p = groupMember.split("\\."))[1].equalsIgnoreCase(user)) continue;
            return true;
        }
        return false;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isModerator() {
        return this.moderator;
    }

    public boolean isAuthor() {
        return this.author;
    }

    public boolean isAudience() {
        return this.audience;
    }
}

