/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.controller;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AdminController {
    @Autowired
    private IAnnouncementService announcementService;

    @RequestMapping
    public String showBaseView(RenderRequest request, Model model) {
        List allTopics = this.announcementService.getAllTopics();
        if (UserPermissionChecker.isPortalAdmin((PortletRequest)request)) {
            model.addAttribute("allTopics", (Object)this.announcementService.getAllTopics());
            model.addAttribute("portalAdmin", (Object)new Boolean(true));
        } else {
            ArrayList<Topic> adminTopics = new ArrayList<Topic>();
            ArrayList<Topic> otherTopics = new ArrayList<Topic>();
            for (Topic t : allTopics) {
                if (UserPermissionChecker.inRoleForTopic((PortletRequest)request, (String)"admins", (Topic)t)) {
                    adminTopics.add(t);
                    continue;
                }
                if (UserPermissionChecker.inRoleForTopic((PortletRequest)request, (String)"moderators", (Topic)t)) {
                    otherTopics.add(t);
                    continue;
                }
                if (!UserPermissionChecker.inRoleForTopic((PortletRequest)request, (String)"authors", (Topic)t)) continue;
                otherTopics.add(t);
            }
            model.addAttribute("adminTopics", adminTopics);
            model.addAttribute("otherTopics", otherTopics);
            model.addAttribute("portalAdmin", (Object)Boolean.FALSE);
        }
        return "baseAdmin";
    }

    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }
}

