/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.jasig.portlet.announcements.UnauthorizedException;
import org.jasig.portlet.announcements.controller.IViewNameSelector;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.TopicSubscription;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.ITopicSubscriptionService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AnnouncementsViewController
implements InitializingBean {
    private static final String GUEST_USERNAME = "guest";
    private static final String PREFERENCE_DISPLAY_STARTDATE = "AnnouncementsViewController.displayPublishDate";
    private static final Logger logger = Logger.getLogger(AnnouncementsViewController.class);
    private Cache guestAnnouncementCache = null;
    private Boolean showDate = Boolean.TRUE;
    @Autowired
    private ITopicSubscriptionService tss = null;
    @Autowired
    private IAnnouncementService announcementService = null;
    @Autowired
    private CacheManager cm = null;
    @Autowired(required=true)
    private IViewNameSelector viewNameSelector = null;
    public static final String PREFERENCE_DISABLE_EDIT = "AnnouncementsViewController.PREFERENCE_DISABLE_EDIT";
    public static final String PREFERENCE_PAGE_SIZE = "AnnouncementsViewController.PAGE_SIZE";

    @RequestMapping(value={"VIEW"})
    public String mainView(Model model, RenderRequest request, @RequestParam(value="from", required=false) Integer from, @RequestParam(value="to", required=false) Integer to) throws PortletException {
        List emergencyAnnouncements;
        List announcements;
        PortletPreferences prefs = request.getPreferences();
        int pageSize = Integer.valueOf(prefs.getValue(PREFERENCE_PAGE_SIZE, "5"));
        if (from == null || to == null) {
            from = 0;
            to = pageSize;
        }
        boolean isGuest = request.getRemoteUser() == null || request.getRemoteUser().equalsIgnoreCase(GUEST_USERNAME);
        logger.debug((Object)("isGuest is: " + Boolean.toString(isGuest)));
        logger.debug((Object)("remoteUser is: " + request.getRemoteUser()));
        Element guestCacheElement = null;
        Element emergCacheElement = null;
        guestCacheElement = this.guestAnnouncementCache.get((Serializable)((Object)GUEST_USERNAME));
        emergCacheElement = this.guestAnnouncementCache.get((Serializable)((Object)"emergency"));
        if (!isGuest || guestCacheElement == null || emergCacheElement == null) {
            announcements = new ArrayList();
            emergencyAnnouncements = new ArrayList();
            List myTopics = this.tss.getTopicSubscription(request);
            for (TopicSubscription ts : myTopics) {
                if (ts.getSubscribed().booleanValue() && ts.getTopic().getSubscriptionMethod() != 4) {
                    announcements.addAll(ts.getTopic().getPublishedAnnouncements());
                    continue;
                }
                if (!ts.getSubscribed().booleanValue() || ts.getTopic().getSubscriptionMethod() != 4) continue;
                emergencyAnnouncements.addAll(ts.getTopic().getPublishedAnnouncements());
            }
            Collections.sort(announcements);
            Collections.sort(emergencyAnnouncements);
            if (isGuest) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Guest cache expired. Regenerating guest cache.");
                }
                this.guestAnnouncementCache.put(new Element((Object)GUEST_USERNAME, announcements));
                this.guestAnnouncementCache.put(new Element((Object)"emergency", emergencyAnnouncements));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Guest cache valid. Using guest cache.");
            }
            announcements = (List)guestCacheElement.getObjectValue();
            emergencyAnnouncements = (List)emergCacheElement.getObjectValue();
        }
        List announcementsShort = new ArrayList();
        if (announcements.size() < to - from) {
            announcementsShort = announcements;
        } else {
            for (int i = from.intValue(); i < to && announcements.size() > i; ++i) {
                if (announcements.get(i) == null) continue;
                announcementsShort.add(announcements.get(i));
            }
        }
        model.addAttribute("isGuest", (Object)isGuest);
        Boolean disableEdit = Boolean.valueOf(prefs.getValue(PREFERENCE_DISABLE_EDIT, "false"));
        model.addAttribute("disableEdit", (Object)disableEdit);
        model.addAttribute("showDate", (Object)this.showDate);
        model.addAttribute("from", (Object)new Integer(from));
        model.addAttribute("to", (Object)new Integer(to));
        model.addAttribute("hasMore", (Object)(announcements.size() > to ? 1 : 0));
        model.addAttribute("increment", (Object)new Integer(pageSize));
        model.addAttribute("announcements", announcementsShort);
        model.addAttribute("emergency", emergencyAnnouncements);
        return this.viewNameSelector.select((PortletRequest)request, "displayAnnouncements");
    }

    @RequestMapping(value={"VIEW"}, params={"action=displayFullAnnouncement"})
    public String displayFullAnnouncement(Model model, RenderRequest request, @RequestParam(value="announcementId") String announcementId) throws Exception {
        Long annId = Long.valueOf(announcementId);
        Announcement announcement = this.announcementService.getAnnouncement(annId);
        if (!UserPermissionChecker.inRoleForTopic((PortletRequest)request, (String)"audience", (Topic)announcement.getParent())) {
            throw new UnauthorizedException();
        }
        model.addAttribute("announcement", (Object)announcement);
        return this.viewNameSelector.select((PortletRequest)request, "displayFullAnnouncement");
    }

    @RequestMapping(value={"EDIT"})
    public String editPreferences(Model model, RenderRequest request) throws PortletException {
        List myTopics = this.tss.getTopicSubscriptionEdit(request);
        if (request.getRemoteUser() == null || request.getRemoteUser().equalsIgnoreCase(GUEST_USERNAME)) {
            model.addAttribute("isGuest", (Object)Boolean.TRUE);
        } else {
            model.addAttribute("isGuest", (Object)Boolean.FALSE);
        }
        model.addAttribute("topicSubscriptions", (Object)myTopics);
        model.addAttribute("topicsToUpdate", (Object)myTopics.size());
        return this.viewNameSelector.select((PortletRequest)request, "editDisplayPreferences");
    }

    @RequestMapping(value={"EDIT"})
    public void savePreferences(ActionRequest request, ActionResponse response, @RequestParam(value="topicsToUpdate") Integer topicsToUpdate) throws PortletException {
        ArrayList<TopicSubscription> newSubscription = new ArrayList<TopicSubscription>();
        for (int i = 0; i < topicsToUpdate; ++i) {
            Long topicId = Long.valueOf(request.getParameter("topicId_" + i));
            String topicSubId = request.getParameter("topicSubId_" + i).trim();
            Boolean subscribed = Boolean.valueOf(request.getParameter("subscribed_" + i));
            Topic topic = this.announcementService.getTopic(topicId);
            if (topic.getSubscriptionMethod() == 1) {
                subscribed = new Boolean(true);
            }
            TopicSubscription ts = new TopicSubscription(request.getRemoteUser(), topic, subscribed);
            if (topicSubId.length() > 0) {
                try {
                    ts.setId(Long.valueOf(topicSubId));
                }
                catch (NumberFormatException nfe) {
                    logger.debug((Object)nfe.getMessage(), (Throwable)nfe);
                }
            }
            newSubscription.add(ts);
        }
        if (newSubscription.size() > 0) {
            try {
                this.announcementService.addOrSaveTopicSubscription(newSubscription);
            }
            catch (Exception e) {
                logger.error((Object)("ERROR saving TopicSubscriptions for user " + request.getRemoteUser() + ". Message: " + e.getMessage()));
            }
        }
        response.setPortletMode(PortletMode.VIEW);
        response.setRenderParameter("action", "displayAnnouncements");
    }

    @ModelAttribute(value="displayPublishDate")
    public boolean getDisplayPublishDate(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        return Boolean.parseBoolean(prefs.getValue(PREFERENCE_DISPLAY_STARTDATE, "false"));
    }

    public void setTss(ITopicSubscriptionService tss) {
        this.tss = tss;
    }

    public void setShowDate(Boolean showDate) {
        this.showDate = showDate;
    }

    public void afterPropertiesSet() throws Exception {
        this.guestAnnouncementCache = this.cm.getCache("guestAnnouncementCache");
        if (this.guestAnnouncementCache == null) {
            throw new BeanCreationException("Required guestAnnouncementCache could not be loaded.");
        }
        logger.debug((Object)"guestAnnouncementCache created.");
    }

    public void setCm(CacheManager cm) {
        this.cm = cm;
    }
}

