/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.model;

import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.jasig.portlet.announcements.model.Announcement;

public class Topic {
    public static final int PUSHED_FORCED = 1;
    public static final int PUSHED_INITIAL = 2;
    public static final int PULLED = 3;
    public static final int EMERGENCY = 4;
    private Set<Announcement> announcements;
    private Set<String> admins = new TreeSet();
    private Set<String> moderators = new TreeSet();
    private Set<String> authors = new TreeSet();
    private Set<String> audience = new TreeSet();
    private String creator;
    private String title;
    private String description;
    private boolean allowRss;
    private int subscriptionMethod;
    private Long id;

    public Set<String> getGroup(String key) {
        if (key.compareTo("admins") == 0) {
            return this.getAdmins();
        }
        if (key.compareTo("moderators") == 0) {
            return this.getModerators();
        }
        if (key.compareTo("authors") == 0) {
            return this.getAuthors();
        }
        return this.getAudience();
    }

    public void setGroup(String key, Set<String> members) {
        if (key.compareTo("admins") == 0) {
            this.setAdmins(members);
        } else if (key.compareTo("moderators") == 0) {
            this.setModerators(members);
        } else if (key.compareTo("authors") == 0) {
            this.setAuthors(members);
        } else {
            this.setAudience(members);
        }
    }

    public boolean hasId() {
        return this.id != null;
    }

    public Set<String> getModerators() {
        return this.moderators;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAllowRss() {
        return this.allowRss;
    }

    public void setModerators(Set<String> moderators) {
        this.moderators = moderators;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAllowRss(boolean allowRss) {
        this.allowRss = allowRss;
    }

    public Set<Announcement> getAnnouncements() {
        return this.announcements;
    }

    public Set<Announcement> getPublishedAnnouncements() {
        TreeSet<Announcement> announcementsFiltered = new TreeSet<Announcement>();
        Date now = new Date();
        if (this.announcements != null) {
            for (Announcement ann : this.announcements) {
                Date startDisplay = ann.getStartDisplay();
                Date endDisplay = ann.getEndDisplay();
                if (endDisplay == null) {
                    long aYearFromNow = System.currentTimeMillis() + 31536000000L;
                    endDisplay = new Date(aYearFromNow);
                }
                if (!ann.isPublished().booleanValue() || !startDisplay.before(now) || !endDisplay.after(now)) continue;
                announcementsFiltered.add(ann);
            }
        }
        return announcementsFiltered;
    }

    public int getDisplayingAnnouncementCount() {
        return this.getPublishedAnnouncements().size();
    }

    public int getScheduledAnnouncementCount() {
        int count = 0;
        Date now = new Date();
        if (this.announcements != null) {
            for (Announcement ann : this.announcements) {
                if (!ann.isPublished().booleanValue() || !ann.getStartDisplay().after(now)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getPendingAnnouncementCount() {
        int count = 0;
        if (this.announcements != null) {
            for (Announcement ann : this.announcements) {
                if (ann.isPublished().booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    public Long getId() {
        return this.id;
    }

    public void setAnnouncements(Set<Announcement> announcements) {
        this.announcements = announcements;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(Set<String> authors) {
        this.authors = authors;
    }

    public Set<String> getAdmins() {
        return this.admins;
    }

    public Set<String> getAudience() {
        return this.audience;
    }

    public void setAdmins(Set<String> admins) {
        this.admins = admins;
    }

    public void setAudience(Set<String> audience) {
        this.audience = audience;
    }

    public int getSubscriptionMethod() {
        return this.subscriptionMethod;
    }

    public void setSubscriptionMethod(int subscriptionMethod) {
        this.subscriptionMethod = subscriptionMethod;
    }

    public boolean equals(Object obj) {
        Topic t = (Topic)obj;
        return t.getId().compareTo(this.id) == 0;
    }

    public String toString() {
        return "Topic [allowRss=" + this.allowRss + ", creator=" + this.creator + ", description=" + this.description + ", id=" + this.id + ", moderators=" + this.moderators + ", subscriptionMethod=" + this.subscriptionMethod + ", title=" + this.title + "]";
    }
}

