/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.jasig.portlet.announcements.service.IAnnouncementService;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnnouncementCleanupThread
extends Thread {
    private IAnnouncementService announcementService;
    private int hourToCheck = 3;
    private int minuteToCheck = 0;
    private int checkInterval = 60;
    private long maxCheckIntervalMillis = 43200000L;
    private boolean keepRunning;
    private static Logger log = Logger.getLogger(AnnouncementCleanupThread.class);

    public AnnouncementCleanupThread() {
        this.setDaemon(true);
        this.keepRunning = true;
    }

    public void stopThread() {
        this.keepRunning = false;
        log.info((Object)"Stopping cleanup thread...");
        this.interrupt();
    }

    @Override
    public void run() {
        GregorianCalendar nowCal = new GregorianCalendar();
        long lastCheckTime = System.currentTimeMillis();
        boolean firstCheck = true;
        while (this.keepRunning) {
            Date now = new Date();
            nowCal.setTime(now);
            if (nowCal.get(11) == this.hourToCheck && nowCal.get(12) <= this.minuteToCheck + 1 && (firstCheck || System.currentTimeMillis() > lastCheckTime + this.maxCheckIntervalMillis)) {
                log.info((Object)("Going to delete old announcements at " + now.toString()));
                this.announcementService.deleteAnnouncementsPastCurrentTime();
                lastCheckTime = System.currentTimeMillis();
                firstCheck = false;
            }
            try {
                log.trace((Object)"Waiting to see if we should check the time...");
                AnnouncementCleanupThread.sleep((long)(this.checkInterval * 1000));
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    public void setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setHourToCheck(int hourToCheck) {
        this.hourToCheck = hourToCheck;
    }

    public void setMinuteToCheck(int minuteToCheck) {
        this.minuteToCheck = minuteToCheck;
    }

    public void setMaxCheckIntervalMillis(long maxCheckIntervalMillis) {
        this.maxCheckIntervalMillis = maxCheckIntervalMillis;
    }
}

