/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.TopicSubscription;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.ITopicSubscriptionService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;
import org.springframework.beans.factory.annotation.Autowired;

public class PortletPreferencesTopicSubscriptionService
implements ITopicSubscriptionService {
    private IAnnouncementService announcementService;
    private Log log = LogFactory.getLog(this.getClass());
    public static final String PREFERENCE_TOPIC_WHITELIST = "PortletPreferencesTopicSubscriptionService.topicWhitelist";
    public static final String PREFERENCE_TOPICS_ADDED = "PortletPreferencesTopicSubscriptionService.topicsAdded";
    public static final String PREFERENCE_TOPICS_REMOVED = "PortletPreferencesTopicSubscriptionService.topicsRemoved";
    public static final String UNAUTHENTICATED_USER = "guest";

    public List<TopicSubscription> getTopicSubscription(RenderRequest req, boolean includeEmergency) throws PortletException {
        ArrayList<TopicSubscription> rslt = new ArrayList<TopicSubscription>();
        String username = req.getRemoteUser();
        if (username == null) {
            username = UNAUTHENTICATED_USER;
        }
        PortletPreferences prefs = req.getPreferences();
        List<String> whitelist = Arrays.asList(prefs.getValues(PREFERENCE_TOPIC_WHITELIST, new String[0]));
        List<String> topicsAdded = Arrays.asList(prefs.getValues(PREFERENCE_TOPICS_ADDED, new String[0]));
        List<String> topicsRemoved = Arrays.asList(prefs.getValues(PREFERENCE_TOPICS_REMOVED, new String[0]));
        List topics = this.announcementService.getAllTopics();
        for (Topic p : topics) {
            String title = p.getTitle();
            if (!whitelist.contains(title)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Topic '" + title + "' removed from user '" + username + "' because it's not on the whitelist"));
                continue;
            }
            if (!UserPermissionChecker.inRoleForTopic((PortletRequest)req, (String)"audience", (Topic)p)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Topic '" + title + "' removed from user '" + username + "' because he/she is not in the audience"));
                continue;
            }
            TopicSubscription ts = new TopicSubscription(username, p, Boolean.valueOf(true));
            if (p.getSubscriptionMethod() == 3 && !topicsAdded.contains(title)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Topic '" + title + "' disabled for user '" + username + "' because he/she did not opt-in"));
                }
                ts.setSubscribed(Boolean.valueOf(false));
            }
            if (p.getSubscriptionMethod() == 2 && topicsRemoved.contains(title)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Topic '" + title + "' disabled for user '" + username + "' because he/she opted-out"));
                }
                ts.setSubscribed(Boolean.valueOf(false));
            }
            rslt.add(ts);
        }
        return rslt;
    }

    public List<TopicSubscription> getTopicSubscription(RenderRequest req) throws PortletException {
        return this.getTopicSubscription(req, true);
    }

    public List<TopicSubscription> getTopicSubscriptionEdit(RenderRequest req) throws PortletException {
        return this.getTopicSubscription(req, false);
    }

    @Autowired
    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }
}

