/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.util.Set;
import javax.portlet.PortletRequest;
import org.jasig.portlet.announcements.model.Topic;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserPermissionChecker {
    public boolean admin;
    public boolean moderator;
    public boolean author;
    public boolean audience;
    public String userName;
    private static final String ADMIN_ROLE_NAME = "Portal_Administrators";

    public UserPermissionChecker(PortletRequest request, Topic topic) {
        String user = request.getRemoteUser();
        if (user == null) {
            user = "guest";
        }
        this.admin = UserPermissionChecker.inRoleForTopic((PortletRequest)request, (String)"admins", (Topic)topic);
        this.moderator = UserPermissionChecker.inRoleForTopic((PortletRequest)request, (String)"moderators", (Topic)topic);
        this.author = UserPermissionChecker.inRoleForTopic((PortletRequest)request, (String)"authors", (Topic)topic);
        this.audience = UserPermissionChecker.inRoleForTopic((PortletRequest)request, (String)"audience", (Topic)topic);
        this.userName = user;
        if (request.isUserInRole("Portal_Administrators")) {
            this.admin = true;
        }
        if (this.admin) {
            this.moderator = true;
        }
        if (this.moderator) {
            this.author = true;
        }
    }

    public static boolean isPortalAdmin(PortletRequest request) {
        return request.isUserInRole("Portal_Administrators");
    }

    public static boolean inRoleForTopic(PortletRequest request, String role, Topic topic) {
        boolean isGuest;
        boolean bl = isGuest = request.getRemoteUser() == null;
        if (!isGuest && UserPermissionChecker.isPortalAdmin((PortletRequest)request)) {
            return true;
        }
        String user = request.getRemoteUser();
        if (isGuest) {
            user = "guest";
        }
        Set group = topic.getGroup(role);
        for (String groupMember : group) {
            String[] p;
            if (request.isUserInRole(groupMember)) {
                return true;
            }
            if (!groupMember.startsWith("USER.") || !(p = groupMember.split("\\."))[1].equalsIgnoreCase(user)) continue;
            return true;
        }
        return false;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isModerator() {
        return this.moderator;
    }

    public boolean isAuthor() {
        return this.author;
    }

    public boolean isAudience() {
        return this.audience;
    }
}

