/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.util.Set;
import javax.portlet.PortletRequest;
import org.jasig.portlet.announcements.UnauthorizedException;
import org.jasig.portlet.announcements.model.Topic;

public final class UserPermissionChecker {
    public static final String PORTAL_ADMIN_ROLE_NAME = "Portal_Administrators";
    public static final String ADMIN_ROLE_NAME = "admin";
    public static final String MODERATOR_ROLE_NAME = "moderator";
    public static final String AUTHOR_ROLE_NAME = "author";
    public static final String AUDIENCE_ROLE_NAME = "audience";
    public static final String GUEST_USERNAME = "guest";
    private final boolean admin;
    private final boolean moderator;
    private final boolean author;
    private final boolean audience;
    private final String userName;
    private final boolean guest;

    UserPermissionChecker(PortletRequest request, Topic topic) {
        this.guest = request.getRemoteUser() == null;
        String string = this.userName = this.guest ? GUEST_USERNAME : request.getRemoteUser();
        if (request.isUserInRole(PORTAL_ADMIN_ROLE_NAME) || UserPermissionChecker.inRoleForTopic(request, ADMIN_ROLE_NAME, topic)) {
            this.author = true;
            this.moderator = true;
            this.admin = true;
        } else if (UserPermissionChecker.inRoleForTopic(request, MODERATOR_ROLE_NAME, topic)) {
            this.admin = false;
            this.author = true;
            this.moderator = true;
        } else if (UserPermissionChecker.inRoleForTopic(request, AUTHOR_ROLE_NAME, topic)) {
            this.moderator = false;
            this.admin = false;
            this.author = true;
        } else {
            this.author = false;
            this.moderator = false;
            this.admin = false;
        }
        this.audience = UserPermissionChecker.inRoleForTopic(request, AUDIENCE_ROLE_NAME, topic);
    }

    public static boolean inRoleForTopic(PortletRequest request, String role, Topic topic) {
        boolean isGuest;
        boolean bl = isGuest = request.getRemoteUser() == null;
        if (!isGuest && UserPermissionChecker.isPortalAdmin(request)) {
            return true;
        }
        String userName = isGuest ? GUEST_USERNAME : request.getRemoteUser();
        Set<String> group = topic.getGroup(role);
        for (String groupMember : group) {
            String[] p;
            if (!(groupMember.startsWith("USER.") ? (p = groupMember.split("\\."))[1].equalsIgnoreCase(userName) : request.isUserInRole(groupMember))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortalAdmin(PortletRequest request) {
        return request.isUserInRole(PORTAL_ADMIN_ROLE_NAME);
    }

    public boolean isGuest() {
        return this.guest;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isModerator() {
        return this.moderator;
    }

    public boolean isAuthor() {
        return this.author;
    }

    public boolean isAudience() {
        return this.audience;
    }

    public boolean canEditTopic() {
        return this.isAuthor() || this.isModerator() || this.isAdmin();
    }

    public void validateCanEditTopic() {
        if (!this.canEditTopic()) {
            throw new UnauthorizedException("You do not have access to this topic!");
        }
    }
}

