/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.xml.namespace.QName;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.jasig.portlet.announcements.UnauthorizedException;
import org.jasig.portlet.announcements.controller.IViewNameSelector;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.AnnouncementSortStrategy;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.TopicSubscription;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.ITopicSubscriptionService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;
import org.jasig.portlet.announcements.service.UserPermissionCheckerFactory;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationQuery;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.NotificationResult;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AnnouncementsViewController
implements InitializingBean {
    private static final String GUEST_USERNAME = "guest";
    private static final Logger logger = Logger.getLogger(AnnouncementsViewController.class);
    private Cache guestAnnouncementCache = null;
    @Autowired
    private ITopicSubscriptionService tss = null;
    @Autowired
    private final IAnnouncementService announcementService = null;
    @Autowired
    private CacheManager cm = null;
    @Autowired(required=true)
    private final IViewNameSelector viewNameSelector = null;
    @Autowired
    private final UserPermissionCheckerFactory userPermissionCheckerFactory = null;
    public static final String PREFERENCE_DISPLAY_STARTDATE = "AnnouncementsViewController.displayPublishDate";
    public static final String PREFERENCE_DISABLE_EDIT = "AnnouncementsViewController.PREFERENCE_DISABLE_EDIT";
    public static final String PREFERENCE_PAGE_SIZE = "AnnouncementsViewController.PAGE_SIZE";
    public static final String PREFERENCE_SORT_STRATEGY = "AnnouncementsViewController.AnnouncementSortStrategy";
    public static final String PREFERENCE_USE_SCROLLING_DISPLAY = "AnnouncementsViewController.useScrollingDisplay";
    public static final String PREFERENCE_SCROLLING_DISPLAY_HEIGHT_PIXELS = "AnnouncementsViewController.scrollingDisplayHeightPixels";
    public static final String PREFERENCE_HIDE_ABSTRACT = "AnnouncementsViewController.hideAbstract";
    public static final String PREFERENCE_SYNDICATE_TOPICS_AS_NOTIFICATIONS = "AnnouncementsViewController.syndicateTopicsAsNotifications";
    public static final String DEFAULT_SORT_STRATEGY = "START_DISPLAY_DATE_ASCENDING";
    public static final String NOTIFICATION_NAMESPACE = "https://source.jasig.org/schemas/portlet/notification";
    public static final String NOTIFICATION_QUERY_LOCAL_NAME = "NotificationQuery";
    public static final QName NOTIFICATION_QUERY_QNAME = new QName("https://source.jasig.org/schemas/portlet/notification", "NotificationQuery");
    public static final String NOTIFICATION_QUERY_QNAME_STRING = "{https://source.jasig.org/schemas/portlet/notification}NotificationQuery";
    public static final String NOTIFICATION_RESULT_LOCAL_NAME = "NotificationResult";
    public static final QName NOTIFICATION_RESULT_QNAME = new QName("https://source.jasig.org/schemas/portlet/notification", "NotificationResult");
    public static final String NOTIFICATION_RESULT_QNAME_STRING = "{https://source.jasig.org/schemas/portlet/notification}NotificationResult";

    @RenderMapping
    public String mainView(Model model, RenderRequest request, @RequestParam(value="from", required=false) Integer from, @RequestParam(value="to", required=false) Integer to) throws PortletException {
        List emergencyAnnouncements;
        List announcements;
        if (from == null || to == null) {
            from = 0;
            to = (Integer)model.asMap().get("increment");
        }
        PortletPreferences prefs = request.getPreferences();
        Element guestCacheElement = null;
        Element emergCacheElement = null;
        guestCacheElement = this.guestAnnouncementCache.get((Serializable)((Object)GUEST_USERNAME));
        emergCacheElement = this.guestAnnouncementCache.get((Serializable)((Object)"emergency"));
        boolean isGuest = (Boolean)model.asMap().get("isGuest");
        if (!isGuest || guestCacheElement == null || emergCacheElement == null) {
            announcements = new ArrayList();
            emergencyAnnouncements = new ArrayList();
            List myTopics = this.tss.getTopicSubscription((PortletRequest)request);
            for (TopicSubscription ts : myTopics) {
                if (ts.getSubscribed().booleanValue() && ts.getTopic().getSubscriptionMethod() != 4) {
                    announcements.addAll(ts.getTopic().getPublishedAnnouncements());
                    continue;
                }
                if (!ts.getSubscribed().booleanValue() || ts.getTopic().getSubscriptionMethod() != 4) continue;
                emergencyAnnouncements.addAll(ts.getTopic().getPublishedAnnouncements());
            }
            Comparator sortStrategy = AnnouncementSortStrategy.getStrategy((String)prefs.getValue(PREFERENCE_SORT_STRATEGY, DEFAULT_SORT_STRATEGY));
            Collections.sort(announcements, sortStrategy);
            Collections.sort(emergencyAnnouncements, sortStrategy);
            if (isGuest) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Guest cache expired. Regenerating guest cache.");
                }
                this.guestAnnouncementCache.put(new Element((Object)GUEST_USERNAME, announcements));
                this.guestAnnouncementCache.put(new Element((Object)"emergency", emergencyAnnouncements));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Guest cache valid. Using guest cache.");
            }
            announcements = (List)guestCacheElement.getObjectValue();
            emergencyAnnouncements = (List)emergCacheElement.getObjectValue();
        }
        boolean useScrollingDisplay = (Boolean)model.asMap().get("useScrollingDisplay");
        List announcementsShort = useScrollingDisplay ? announcements : this.paginateAnnouncements(announcements, from, to, model);
        Boolean disableEdit = Boolean.valueOf(prefs.getValue(PREFERENCE_DISABLE_EDIT, "false"));
        model.addAttribute("disableEdit", (Object)disableEdit);
        model.addAttribute("from", (Object)new Integer(from));
        model.addAttribute("to", (Object)new Integer(to));
        model.addAttribute("hasMore", (Object)(!useScrollingDisplay && announcements.size() > to ? 1 : 0));
        model.addAttribute("announcements", announcementsShort);
        model.addAttribute("emergency", emergencyAnnouncements);
        model.addAttribute("hideAbstract", (Object)Boolean.valueOf(prefs.getValue(PREFERENCE_HIDE_ABSTRACT, "false")));
        return this.viewNameSelector.select((PortletRequest)request, "displayAnnouncements");
    }

    @RenderMapping(params={"action=displayFullAnnouncement"})
    public String displayFullAnnouncement(Model model, RenderRequest request, @RequestParam(value="announcementId") String announcementId) throws Exception {
        Announcement announcement = this.getAnnouncementById((PortletRequest)request, announcementId);
        model.addAttribute("announcement", (Object)announcement);
        return this.viewNameSelector.select((PortletRequest)request, "displayFullAnnouncement");
    }

    @EventMapping(value="{https://source.jasig.org/schemas/portlet/notification}NotificationQuery")
    public void syndicateAnnouncementsAsNotifications(EventRequest req, EventResponse res) throws PortletException {
        PortletPreferences prefs = req.getPreferences();
        List<String> topicTitlesToSyndicate = Arrays.asList(prefs.getValues(PREFERENCE_SYNDICATE_TOPICS_AS_NOTIFICATIONS, new String[0]));
        if (topicTitlesToSyndicate.isEmpty()) {
            return;
        }
        ArrayList<NotificationCategory> categories = new ArrayList<NotificationCategory>();
        List myTopics = this.tss.getTopicSubscription((PortletRequest)req);
        for (TopicSubscription topicSub : myTopics) {
            Set announcements;
            Topic topic = topicSub.getTopic();
            if (!topicTitlesToSyndicate.contains(topic.getTitle()) || (announcements = topic.getPublishedAnnouncements()).isEmpty()) continue;
            ArrayList<NotificationEntry> entries = new ArrayList<NotificationEntry>();
            for (Announcement ann : announcements) {
                NotificationEntry entry = new NotificationEntry();
                entry.setTitle(ann.getTitle());
                entry.setBody(ann.getAbstractText());
                entry.setSource("Announcements");
                StringBuilder url = new StringBuilder();
                url.append("/uPortal").append("/p/").append("AnnouncementsDisplay").append("/max/render.uP?pP_action=displayFullAnnouncement&pP_announcementId=").append(ann.getId());
                entry.setUrl(url.toString());
                entries.add(entry);
            }
            NotificationCategory category = new NotificationCategory();
            category.setTitle(topic.getTitle());
            category.setEntries(entries);
            categories.add(category);
        }
        if (categories.isEmpty()) {
            return;
        }
        NotificationQuery query = (NotificationQuery)req.getEvent().getValue();
        NotificationResponse response = new NotificationResponse();
        response.setCategories(categories);
        NotificationResult result = new NotificationResult();
        result.setQueryWindowId(query.getQueryWindowId());
        result.setResultWindowId(req.getWindowID());
        result.setNotificationResponse(response);
        res.setEvent(NOTIFICATION_RESULT_QNAME, (Serializable)result);
    }

    @ModelAttribute(value="displayPublishDate")
    public boolean getDisplayPublishDate(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        return Boolean.parseBoolean(prefs.getValue(PREFERENCE_DISPLAY_STARTDATE, "false"));
    }

    public void setTss(ITopicSubscriptionService tss) {
        this.tss = tss;
    }

    public void afterPropertiesSet() throws Exception {
        this.guestAnnouncementCache = this.cm.getCache("guestAnnouncementCache");
        if (this.guestAnnouncementCache == null) {
            throw new BeanCreationException("Required guestAnnouncementCache could not be loaded.");
        }
        logger.debug((Object)"guestAnnouncementCache created.");
    }

    public void setCm(CacheManager cm) {
        this.cm = cm;
    }

    @RenderMapping(params={"action=displayFullAnnouncementHistory"})
    public String displayFullAnnouncementHistory(Model model, RenderRequest request, @RequestParam(value="announcementId") String announcementId) throws Exception {
        Announcement announcement = this.getAnnouncementById((PortletRequest)request, announcementId);
        model.addAttribute("announcement", (Object)announcement);
        return this.viewNameSelector.select((PortletRequest)request, "displayFullAnnouncementHistory");
    }

    @RenderMapping(params={"action=displayHistory"})
    public String displayHistory(Model model, RenderRequest request) throws Exception {
        ArrayList announcements = new ArrayList();
        List myTopics = this.tss.getTopicSubscription((PortletRequest)request);
        for (TopicSubscription ts : myTopics) {
            if (!ts.getSubscribed().booleanValue() || ts.getTopic().getSubscriptionMethod() == 4) continue;
            announcements.addAll(ts.getTopic().getHistoricAnnouncements());
        }
        Collections.sort(announcements, new /* Unavailable Anonymous Inner Class!! */);
        model.addAttribute("announcements", announcements);
        return this.viewNameSelector.select((PortletRequest)request, "displayHistory");
    }

    @ModelAttribute(value="increment")
    public int getPageSize(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        int rslt = 5;
        try {
            rslt = Integer.parseInt(prefs.getValue(PREFERENCE_PAGE_SIZE, "5"));
        }
        catch (NumberFormatException nfe) {
            logger.warn((Object)("Non-integer value encountered for AnnouncementsViewController.PAGE_SIZE: " + prefs.getValue(PREFERENCE_PAGE_SIZE, null)));
        }
        return rslt;
    }

    @ModelAttribute(value="isGuest")
    public boolean isGuest(PortletRequest req) {
        boolean rslt = req.getRemoteUser() == null || req.getRemoteUser().equalsIgnoreCase(GUEST_USERNAME);
        logger.debug((Object)("isGuest is: " + Boolean.toString(rslt)));
        logger.debug((Object)("remoteUser is: " + req.getRemoteUser()));
        return rslt;
    }

    @ModelAttribute(value="useScrollingDisplay")
    public boolean getUseScrollingDisplay(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        return Boolean.valueOf(prefs.getValue(PREFERENCE_USE_SCROLLING_DISPLAY, "false"));
    }

    @ModelAttribute(value="scrollingDisplayHeightPixels")
    public int getScrollingDisplayHeightPixels(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        int rslt = 500;
        try {
            rslt = Integer.parseInt(prefs.getValue(PREFERENCE_SCROLLING_DISPLAY_HEIGHT_PIXELS, "500"));
        }
        catch (NumberFormatException nfe) {
            logger.warn((Object)("Non-integer value encountered for AnnouncementsViewController.scrollingDisplayHeightPixels: " + prefs.getValue(PREFERENCE_SCROLLING_DISPLAY_HEIGHT_PIXELS, null)));
        }
        return rslt;
    }

    private List<Announcement> paginateAnnouncements(List<Announcement> announcements, Integer from, Integer to, Model model) {
        List<Announcement> rslt;
        if (announcements.size() < to - from) {
            rslt = announcements;
        } else {
            rslt = new ArrayList<Announcement>();
            for (int i = from.intValue(); i < to && announcements.size() > i; ++i) {
                if (announcements.get(i) == null) continue;
                rslt.add(announcements.get(i));
            }
        }
        return rslt;
    }

    private Announcement getAnnouncementById(PortletRequest request, String announcementId) throws Exception {
        Long annId = Long.valueOf(announcementId);
        Announcement announcement = this.announcementService.getAnnouncement(annId);
        if (!UserPermissionChecker.inRoleForTopic((PortletRequest)request, (String)"audience", (Topic)announcement.getParent())) {
            throw new UnauthorizedException();
        }
        return announcement;
    }
}

