/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.util.Calendar;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.TopicSubscription;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateAnnouncementService
extends HibernateDaoSupport
implements IAnnouncementService {
    private static Log log = LogFactory.getLog(HibernateAnnouncementService.class);

    @Override
    public List<Topic> getAllTopics() {
        List result;
        try {
            result = this.getHibernateTemplate().find("from Topic");
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        return result;
    }

    @Override
    public Topic getEmergencyTopic() {
        Topic t = null;
        try {
            List result = this.getHibernateTemplate().find("from Topic where SUB_METHOD = 4");
            t = (Topic)result.get(0);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        return t;
    }

    @Override
    public void addOrSaveTopic(Topic topic) {
        try {
            log.debug((Object)("Insert or save topic: [topicId: " + (topic.getId() != null ? topic.getId().toString() : "NEW") + "]"));
            this.getHibernateTemplate().saveOrUpdate((Object)topic);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void persistTopic(Topic topic) {
        try {
            log.debug((Object)("Persisting topic: [topicId: " + topic.getId().toString() + "]"));
            this.getHibernateTemplate().persist((Object)topic);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void mergeTopic(Topic topic) {
        try {
            log.debug((Object)("Merging topic: [topicId: " + topic.getId().toString() + "]"));
            this.getHibernateTemplate().merge((Object)topic);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void addOrSaveAnnouncement(Announcement ann) {
        try {
            log.debug((Object)("Insert or save announcement: [annId: " + (ann.getId() != null ? ann.getId().toString() : "NEW") + "]"));
            this.getHibernateTemplate().saveOrUpdate((Object)ann);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void mergeAnnouncement(Announcement ann) {
        try {
            log.debug((Object)("Merge announcement: [annId: " + (ann.getId() != null ? ann.getId().toString() : "NEW") + "]"));
            this.getHibernateTemplate().merge((Object)ann);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Topic getTopic(Long id) throws PortletException {
        List result;
        if (id == null) {
            throw new PortletException("Programming error: getTopic called with null parameter");
        }
        try {
            result = this.getHibernateTemplate().find("from Topic where id = '" + id.toString() + "'");
            if (result.size() != 1) {
                throw new PortletException("The requested topic [" + id.toString() + "] does not exist.");
            }
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        return (Topic)result.get(0);
    }

    @Override
    public Announcement getAnnouncement(Long id) throws PortletException {
        List result = null;
        if (id == null) {
            throw new PortletException("Programming error: getAnnouncement called with null parameter");
        }
        try {
            result = this.getHibernateTemplate().find("from Announcement where id = '" + id.toString() + "'");
            if (result.size() != 1) {
                throw new PortletException("The requested announcement [" + id.toString() + "] does not exist.");
            }
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        return (Announcement)result.get(0);
    }

    @Override
    public void deleteAnnouncementsPastCurrentTime() {
        List result = null;
        try {
            result = this.getHibernateTemplate().find("from Announcement where END_DISPLAY < current_timestamp()");
            if (result == null || result.size() == 0) {
                return;
            }
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        if (result.size() > 0) {
            log.info((Object)("Deleting " + result.size() + " expired announcements."));
            try {
                for (Announcement a : result) {
                    this.getHibernateTemplate().delete((Object)a);
                }
                this.getHibernateTemplate().flush();
            }
            catch (HibernateException ex) {
                throw this.convertHibernateAccessException(ex);
            }
        }
    }

    @Override
    public void deleteAnnouncementsPastExpirationThreshold(int numDays) {
        Object result = null;
        try {
            Calendar cal = Calendar.getInstance();
            cal.add(5, numDays * -1);
            Query q = this.getSession().createQuery("delete from Announcement where END_DISPLAY < :date");
            q.setCalendarDate("date", cal);
            int count = q.executeUpdate();
            this.getHibernateTemplate().flush();
            log.info((Object)("Deleted " + count + " expired announcements."));
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public List<TopicSubscription> getTopicSubscriptionFor(PortletRequest request) throws PortletException {
        List result = null;
        try {
            result = this.getHibernateTemplate().find("from TopicSubscription where OWNER_ID = '" + request.getRemoteUser() + "'");
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        return result;
    }

    @Override
    public void addOrSaveTopicSubscription(List<TopicSubscription> subs) {
        try {
            for (TopicSubscription ts : subs) {
                this.getHibernateTemplate().saveOrUpdate((Object)ts);
            }
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void persistTopicSubscription(List<TopicSubscription> subs) {
        try {
            for (TopicSubscription ts : subs) {
                this.getHibernateTemplate().persist((Object)ts);
            }
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void deleteTopic(Topic topic) {
        try {
            Long topicId = topic.getId();
            List result = this.getHibernateTemplate().find("from TopicSubscription where TOPIC_ID = " + topicId.toString());
            for (TopicSubscription ts : result) {
                this.getHibernateTemplate().delete((Object)ts);
            }
            this.getHibernateTemplate().delete((Object)topic);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void deleteAnnouncement(Announcement ann) {
        try {
            this.getHibernateTemplate().delete((Object)ann);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    @Override
    public void deleteTopicSubscription(TopicSubscription sub) {
        try {
            this.getHibernateTemplate().delete((Object)sub);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }
}

