/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.model;

import java.util.Date;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jasig.portlet.announcements.model.AnnouncementSortStrategy;
import org.jasig.portlet.announcements.model.Topic;

@XmlRootElement(name="announcement")
public class Announcement
implements Comparable<Announcement> {
    public static final long MILLISECONDS_IN_A_YEAR = 31536000000L;
    private String title;
    private String abstractText;
    private Date created;
    private Date startDisplay;
    private Date endDisplay;
    private String message;
    private String author;
    private String link;
    private Boolean published = false;
    private Topic parent;
    private Long id;
    private Set<String> attachments;

    @XmlTransient
    public Boolean isPublished() {
        return this.published;
    }

    @XmlElement(name="published")
    public Boolean getPublished() {
        return this.isPublished();
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public boolean hasId() {
        return this.id != null;
    }

    @XmlTransient
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @XmlTransient
    public Topic getParent() {
        return this.parent;
    }

    public void setParent(Topic parent) {
        this.parent = parent;
    }

    @XmlElement(name="title")
    public String getTitle() {
        return this.title;
    }

    @XmlElement(name="created")
    public Date getCreated() {
        return this.created;
    }

    @XmlElement(name="startDisplay")
    public Date getStartDisplay() {
        return this.startDisplay;
    }

    @XmlElement(name="endDisplay")
    public Date getEndDisplay() {
        return this.endDisplay;
    }

    @XmlTransient
    public Date getNullSafeEndDisplay() {
        return this.endDisplay != null ? this.endDisplay : new Date(System.currentTimeMillis() + 31536000000L);
    }

    @XmlElement(name="message")
    public String getMessage() {
        return this.message;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setStartDisplay(Date startDisplay) {
        this.startDisplay = startDisplay;
    }

    public void setEndDisplay(Date endDisplay) {
        this.endDisplay = endDisplay;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @XmlElement(name="abstract")
    public String getAbstractText() {
        return this.abstractText;
    }

    @XmlElement(name="author")
    public String getAuthor() {
        return this.author;
    }

    @XmlElement(name="link")
    public String getLink() {
        return this.link;
    }

    public void setAbstractText(String abstractText) {
        this.abstractText = abstractText;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @XmlElementWrapper(name="attachments")
    @XmlElement(name="attachment")
    public Set<String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Set<String> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object obj) {
        Announcement t = (Announcement)obj;
        return t.getId().compareTo(this.id) == 0;
    }

    @Override
    public int compareTo(Announcement otherAnn) {
        return AnnouncementSortStrategy.START_DISPLAY_DATE_DESCENDING.getComparator().compare(this, otherAnn);
    }
}

