/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.model.Role;
import org.jasig.portlet.announcements.model.RoleSelection;
import org.jasig.portlet.announcements.service.IGroupService;
import org.springframework.web.context.ServletContextAware;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PortletXMLGroupService
implements ServletContextAware,
IGroupService {
    private final String PORTLET_XML_PATH = "/WEB-INF/portlet.xml";
    private Document doc;
    private List<String> roles;
    private static Log log = LogFactory.getLog(PortletXMLGroupService.class);
    private ServletContext context;

    public void init() {
        this.parseXml();
        if (this.doc != null) {
            this.roles = new ArrayList();
            NodeList roleSections = this.doc.getElementsByTagName("security-role-ref");
            for (int i = 0; i < roleSections.getLength(); ++i) {
                if (!roleSections.item(i).hasChildNodes()) continue;
                NodeList roleNames = roleSections.item(i).getChildNodes();
                for (int j = 0; j < roleNames.getLength(); ++j) {
                    String roleNameCandidate;
                    if (!roleNames.item(j).getNodeName().equalsIgnoreCase("role-name") || this.roles.contains(roleNameCandidate = roleNames.item(j).getTextContent())) continue;
                    this.roles.add(roleNameCandidate);
                }
                roleNames = null;
            }
            Collections.sort(this.roles);
            log.info((Object)("Successfully instantiated and found roles [" + this.getRolesPretty() + "]"));
        } else {
            log.error((Object)"Error parsing the file: /WEB-INF/portlet.xml. See other messages for trace.");
        }
    }

    public List<Role> getAllRoles() {
        ArrayList<Role> list = new ArrayList<Role>();
        for (String role : this.roles) {
            list.add(new Role(role, false));
        }
        return list;
    }

    public List<Role> getAllRolesFromGroupSet(Set<String> selected) {
        ArrayList<Role> list = new ArrayList<Role>();
        for (String role : this.roles) {
            if (selected.contains(role)) {
                list.add(new Role(role, true));
                continue;
            }
            list.add(new Role(role, false));
        }
        for (String person : selected) {
            if (!person.startsWith("USER.")) continue;
            list.add(new Role(person, true));
        }
        return list;
    }

    public Set<String> getSetForRoleSelection(RoleSelection roleSel) {
        TreeSet<String> newSet = new TreeSet<String>();
        newSet.addAll(roleSel.getSelectedRoles());
        return newSet;
    }

    private String getRolesPretty() {
        StringBuffer sb = new StringBuffer();
        for (String role : this.roles) {
            sb.append(role + ", ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseXml() {
        URL portletXmlUrl = null;
        try {
            portletXmlUrl = this.context.getResource("/WEB-INF/portlet.xml");
            return;
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage());
            return;
        }
        finally {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                InputSource xmlInp = new InputSource(portletXmlUrl.openStream());
                DocumentBuilder dbl = dbf.newDocumentBuilder();
                this.doc = dbl.parse(xmlInp);
            }
            catch (ParserConfigurationException e) {
                log.error((Object)e.getMessage());
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
            }
            catch (SAXException e) {
                log.error((Object)e.getMessage());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
            finally {
                log.debug((Object)"Finished parsing /WEB-INF/portlet.xml.");
            }
        }
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }
}

