/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.model.TopicSubscription;
import org.jasig.portlet.announcements.service.AnnouncementFilterType;
import org.jasig.portlet.announcements.service.AnnouncementPreferences;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.service.ITopicSubscriptionService;
import org.jasig.portlet.announcements.service.UserConfiguredTopicSubscriptionService;
import org.jasig.portlet.announcements.service.UserPermissionChecker;

public class UserConfiguredTopicSubscriptionService
implements ITopicSubscriptionService {
    public static final String PREFERENCE_FILTER_TYPE = AnnouncementPreferences.FILTER_TYPE.getKey();
    public static final String PREFERENCE_FILTER_ITEMS = AnnouncementPreferences.FILTER_ITEMS.getKey();
    private Log log = LogFactory.getLog(this.getClass());
    private IAnnouncementService announcementService;
    private Topic emergencyTopic;

    public void init() {
        Topic t = null;
        try {
            t = this.announcementService.getEmergencyTopic();
        }
        catch (Exception ex) {
            this.log.error((Object)("Could not load emergencyTopic from database: " + ex.getMessage()));
        }
        if (t == null && this.emergencyTopic != null) {
            this.announcementService.addOrSaveTopic(this.emergencyTopic);
        } else {
            this.emergencyTopic = t;
        }
    }

    public List<TopicSubscription> getTopicSubscription(PortletRequest request, boolean includeEmergency) throws PortletException {
        ArrayList<TopicSubscription> subscriptions = new ArrayList<TopicSubscription>();
        List subSaved = null;
        List allTopics = this.announcementService.getAllTopics();
        if (request.getRemoteUser() == null) {
            subSaved = new ArrayList();
        } else {
            try {
                subSaved = this.announcementService.getTopicSubscriptionFor(request);
            }
            catch (Exception e) {
                this.log.error((Object)("ERROR getting topic subscriptions for " + request.getRemoteUser() + ": " + e.getMessage()));
            }
        }
        String user = request.getRemoteUser();
        if (user == null) {
            user = "guest";
        }
        PortletPreferences prefs = request.getPreferences();
        AnnouncementFilterType filterType = AnnouncementFilterType.valueOf((String)prefs.getValue(PREFERENCE_FILTER_TYPE, AnnouncementFilterType.BLACKLIST.getKey()));
        List<String> filterItems = Arrays.asList(prefs.getValues(PREFERENCE_FILTER_ITEMS, new String[0]));
        if (subSaved != null) {
            this.log.debug((Object)("Found DisplayPrefs for " + user));
            for (Topic topic : allTopics) {
                String title = topic.getTitle();
                if (this.isFiltered(topic, filterType, filterItems)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Topic " + title + " has been filtered from user " + user));
                    continue;
                }
                boolean allowedToViewTopic = false;
                allowedToViewTopic = UserPermissionChecker.inRoleForTopic((PortletRequest)request, (String)"audience", (Topic)topic);
                if (allowedToViewTopic && topic.getSubscriptionMethod() == 1) {
                    TopicSubscription invalid = null;
                    for (TopicSubscription ts : subSaved) {
                        if (!ts.getTopic().equals((Object)topic) || !ts.getSubscribed().equals(Boolean.FALSE)) continue;
                        invalid = ts;
                    }
                    if (invalid != null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Removing invalid TopicSubscription topic [" + topic.getId() + "] for " + user));
                        }
                        subSaved.remove(invalid);
                        this.announcementService.deleteTopicSubscription(invalid);
                    }
                    if (!this.topicSubscriptionExists(topic, subSaved)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Adding missing PUSHED_FORCED topic [" + topic.getId() + "] for " + user));
                        }
                        subscriptions.add(new TopicSubscription(user, topic, new Boolean(true)));
                    }
                } else if (allowedToViewTopic && topic.getSubscriptionMethod() == 2 && !this.topicSubscriptionExists(topic, subSaved)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Adding missing PUSHED_INITIAL topic [" + topic.getId() + "] for " + user));
                    }
                    subscriptions.add(new TopicSubscription(user, topic, new Boolean(true)));
                } else if (allowedToViewTopic && topic.getSubscriptionMethod() == 3 && !this.topicSubscriptionExists(topic, subSaved)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Adding missing PULLED topic [" + topic.getId() + "] for " + user));
                    }
                    subscriptions.add(new TopicSubscription(user, topic, new Boolean(false)));
                }
                if (allowedToViewTopic || !this.topicSubscriptionExists(topic, subSaved)) continue;
                TopicSubscription toRemove = null;
                for (TopicSubscription ts : subSaved) {
                    if (!ts.getTopic().equals((Object)topic)) continue;
                    toRemove = ts;
                }
                if (toRemove == null) continue;
                subSaved.remove(toRemove);
                this.announcementService.deleteTopicSubscription(toRemove);
            }
            subscriptions.addAll(subSaved);
            if (includeEmergency) {
                this.emergencyTopic = this.announcementService.getEmergencyTopic();
                subscriptions.add(new TopicSubscription(user, this.emergencyTopic, new Boolean(true)));
            }
            return subscriptions;
        }
        throw new PortletException("Could not determine/create subscription preferences for user " + user);
    }

    public List<TopicSubscription> getTopicSubscriptionEdit(RenderRequest request) throws PortletException {
        return this.getTopicSubscription((PortletRequest)request, false);
    }

    public List<TopicSubscription> getTopicSubscription(PortletRequest request) throws PortletException {
        return this.getTopicSubscription(request, true);
    }

    private boolean topicSubscriptionExists(Topic topic, List<TopicSubscription> subscriptions) {
        for (TopicSubscription ts : subscriptions) {
            if (ts.getTopic().getId().compareTo(topic.getId()) == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Topic [" + topic.getId() + ": " + topic.getTitle() + "] was found in TopicSubscription [Topic: " + ts.getTopic().getId() + " " + ts.getTopic().getTitle() + "] for " + ts.getOwner()));
                }
                return true;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Topic [" + topic.getId() + ": " + topic.getTitle() + "] is not referenced in TopicSubscription [Topic: " + ts.getTopic().getId() + " " + ts.getTopic().getTitle() + "] for " + ts.getOwner()));
        }
        return false;
    }

    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    public void setEmergencyTopic(Topic emergencyTopic) {
        this.emergencyTopic = emergencyTopic;
        this.log.debug((Object)"Emergency Topic assigned successfully.");
    }

    private boolean isFiltered(Topic topic, AnnouncementFilterType filterType, List<String> filterItems) {
        if (topic == null) {
            return false;
        }
        if (filterItems == null) {
            return false;
        }
        String title = topic.getTitle();
        switch (1.$SwitchMap$org$jasig$portlet$announcements$service$AnnouncementFilterType[filterType.ordinal()]) {
            case 1: {
                return filterItems.contains(title);
            }
            case 2: {
                return !filterItems.contains(title);
            }
        }
        return false;
    }
}

