/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.jasig.portlet.announcements.Importer;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.jasig.portlet.announcements.spring.PortletApplicationContextLocator;
import org.springframework.context.ApplicationContext;

public class Importer {
    private static final String SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private static final String ANNOUNCEMENT_SVC_BEAN_NAME = "announcementService";
    private static final Logger log = Logger.getLogger(Importer.class);
    private String dir;
    private SessionFactory sessionFactory;
    private IAnnouncementService announcementService;
    private List<String> errors = new ArrayList();

    public Importer(String dir, SessionFactory sessionFactory, IAnnouncementService announcementService) {
        this.dir = dir;
        this.sessionFactory = sessionFactory;
        this.announcementService = announcementService;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            log.error((Object)"Invalid number of arguments. Command:\njava org.jasig.portlet.announcements.Importer <dir> <pathToSpringContextXmlFile");
            System.exit(1);
        }
        String dir = args[0];
        String importExportContext = args[1];
        ApplicationContext context = PortletApplicationContextLocator.getApplicationContext((String)importExportContext);
        SessionFactory sessionFactory = (SessionFactory)context.getBean(SESSION_FACTORY_BEAN_NAME, SessionFactory.class);
        IAnnouncementService announcementService = (IAnnouncementService)context.getBean(ANNOUNCEMENT_SVC_BEAN_NAME, IAnnouncementService.class);
        Importer importer = new Importer(dir, sessionFactory, announcementService);
        importer.importData();
        if (importer.errors.size() > 0) {
            log.error((Object)"Import failed - see previous errors");
            System.exit(1);
        }
    }

    public void importData() {
        this.importTopics();
        this.importAnnouncements();
    }

    private void importTopics() {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Topic.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            File folder = new File(this.dir);
            File[] files = folder.listFiles((FileFilter)new TopicImportFileFilter(null));
            if (files == null) {
                this.errors.add("Directory " + this.dir + " is not a valid directory");
            } else {
                for (File f : files) {
                    String msg;
                    log.info((Object)("Processing file " + f.toString()));
                    StreamSource xmlFile = new StreamSource(f.getAbsoluteFile());
                    try {
                        JAXBElement je1 = unmarshaller.unmarshal((Source)xmlFile, Topic.class);
                        Topic topic = (Topic)je1.getValue();
                        if (StringUtils.isBlank((String)topic.getTitle())) {
                            String msg2 = "Error parsing file " + f.toString() + "; did not get valid record:\n" + topic.toString();
                            log.error((Object)msg2);
                            this.errors.add(msg2);
                            continue;
                        }
                        this.announcementService.addOrSaveTopic(topic);
                        log.info((Object)("Successfully imported topic '" + topic.getTitle() + "'"));
                    }
                    catch (JAXBException e) {
                        msg = "JAXB exception " + e.getCause().getMessage() + " processing file " + f.toString();
                        log.error((Object)msg, (Throwable)e);
                        this.errors.add(msg + ". See stack trace");
                    }
                    catch (HibernateException e) {
                        msg = "Hibernate exception " + e.getCause().getMessage() + " processing file " + f.toString();
                        log.error((Object)msg, (Throwable)e);
                        this.errors.add(msg + ". See stack trace");
                    }
                }
            }
        }
        catch (JAXBException e) {
            String msg = "Fatal JAXBException in importTopics - no topics imported";
            log.fatal((Object)msg, (Throwable)e);
            this.errors.add(msg + ".  See stack trace");
        }
    }

    private void importAnnouncements() {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Announcement.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            File folder = new File(this.dir);
            File[] files = folder.listFiles((FileFilter)new AnnouncementImportFileFilter(null));
            if (files == null) {
                this.errors.add("Directory " + this.dir + " is not a valid directory");
            } else {
                for (File f : files) {
                    String msg;
                    log.info((Object)("Processing file " + f.toString()));
                    StreamSource xml = new StreamSource(f.getAbsoluteFile());
                    try {
                        String msg2;
                        JAXBElement je1 = unmarshaller.unmarshal((Source)xml, Announcement.class);
                        Announcement announcement = (Announcement)je1.getValue();
                        if (StringUtils.isBlank((String)announcement.getTitle())) {
                            msg2 = "Error parsing " + f.toString() + "; did not get valid record:\n" + announcement.toString();
                            log.error((Object)msg2);
                            this.errors.add(msg2);
                            continue;
                        }
                        if (announcement.getParent() == null || StringUtils.isBlank((String)announcement.getParent().getTitle())) {
                            msg2 = "Announcement in file " + f.toString() + " does not reference a topic with a title";
                            log.error((Object)msg2);
                            this.errors.add(msg2);
                            continue;
                        }
                        Topic topic = this.findTopicForAnnouncement(announcement);
                        announcement.setParent(topic);
                        this.announcementService.addOrSaveAnnouncement(announcement);
                        log.info((Object)("Successfully imported announcement '" + announcement.getTitle() + "'"));
                    }
                    catch (ImportException e) {
                        log.error((Object)e.getMessage());
                        this.errors.add(e.getMessage());
                    }
                    catch (JAXBException e) {
                        msg = "JAXB exception " + e.getCause().getMessage() + " processing file " + f.toString();
                        log.error((Object)msg, (Throwable)e);
                        this.errors.add(msg + ". See stack trace");
                    }
                    catch (HibernateException e) {
                        msg = "Hibernate exception " + e.getCause().getMessage() + " processing file " + f.toString();
                        log.error((Object)msg, (Throwable)e);
                        this.errors.add(msg + ". See stack trace");
                    }
                }
            }
        }
        catch (JAXBException e) {
            String msg = "Fatal JAXBException in importAnnouncements - no Announcements imported";
            log.fatal((Object)msg, (Throwable)e);
            this.errors.add(msg + ".  See stack trace");
        }
    }

    private Topic findTopicForAnnouncement(Announcement announcement) {
        Topic topic = null;
        List topics = this.announcementService.getAllTopics();
        for (Topic t : topics) {
            if (!t.getTitle().equals(announcement.getParent().getTitle())) continue;
            if (topic != null) {
                throw new ImportException(this, "Unable to import Announcement '" + announcement.getTitle() + "' - multiple topics exist with title '" + t.getTitle() + "'");
            }
            topic = t;
        }
        return topic;
    }
}

