/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.model;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.TopicSubscription;

@XmlType(namespace="http://www.uPortal.org/schema/announcement/topic")
@XmlRootElement(name="topic")
public class Topic {
    public static final int PUSHED_FORCED = 1;
    public static final int PUSHED_INITIAL = 2;
    public static final int PULLED = 3;
    public static final int EMERGENCY = 4;
    private static final Logger logger = Logger.getLogger(Topic.class);
    private Set<Announcement> announcements;
    private Set<TopicSubscription> subscriptions = new HashSet<TopicSubscription>();
    private Set<String> admins = new TreeSet<String>();
    private Set<String> moderators = new TreeSet<String>();
    private Set<String> authors = new TreeSet<String>();
    private Set<String> audience = new TreeSet<String>();
    private String creator;
    private String title;
    private String description;
    private boolean allowRss;
    private int subscriptionMethod;
    private Long id;

    public Set<String> getGroup(String key) {
        if ("admin".equals(key)) {
            return this.getAdmins();
        }
        if ("moderator".equals(key)) {
            return this.getModerators();
        }
        if ("author".equals(key)) {
            return this.getAuthors();
        }
        if ("audience".equals(key)) {
            return this.getAudience();
        }
        throw new RuntimeException("Role not found:  " + key);
    }

    public void setGroup(String key, Set<String> members) {
        if ("admin".equals(key)) {
            this.setAdmins(members);
        } else if ("moderator".equals(key)) {
            this.setModerators(members);
        } else if ("author".equals(key)) {
            this.setAuthors(members);
        } else if ("audience".equals(key)) {
            this.setAudience(members);
        } else {
            throw new RuntimeException("Role not found:  " + key);
        }
    }

    public boolean hasId() {
        return this.id != null;
    }

    @XmlElementWrapper(name="moderators")
    @XmlElement(name="moderator")
    public Set<String> getModerators() {
        return this.moderators;
    }

    @XmlElement(name="creator", defaultValue="system")
    public String getCreator() {
        return this.creator;
    }

    @XmlElement(name="title", required=true)
    public String getTitle() {
        return this.title;
    }

    @XmlElement(name="description")
    public String getDescription() {
        return this.description;
    }

    @XmlElement(name="allowRss")
    public boolean isAllowRss() {
        return this.allowRss;
    }

    public void setModerators(Set<String> moderators) {
        this.moderators = moderators;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAllowRss(boolean allowRss) {
        this.allowRss = allowRss;
    }

    @XmlElementWrapper(name="subscriptions")
    @XmlElement(name="subscription")
    public Set<TopicSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(Set<TopicSubscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    @XmlElementWrapper(name="announcements")
    @XmlElement(name="announcement")
    public Set<Announcement> getAnnouncements() {
        return this.announcements;
    }

    @XmlTransient
    public Set<Announcement> getPublishedAnnouncements() {
        HashSet<Announcement> announcementsFiltered = new HashSet<Announcement>();
        Date now = new Date();
        if (this.announcements != null) {
            for (Announcement ann : this.announcements) {
                Date startDisplay = ann.getStartDisplay();
                Date endDisplay = ann.getEndDisplay();
                if (endDisplay == null) {
                    long aYearFromNow = System.currentTimeMillis() + 31536000000L;
                    endDisplay = new Date(aYearFromNow);
                }
                if (!ann.getPublished().booleanValue() || !startDisplay.before(now) || !endDisplay.after(now)) continue;
                announcementsFiltered.add(ann);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Returning %d of %d announcements", this.announcements.size(), announcementsFiltered.size()));
        }
        return announcementsFiltered;
    }

    @XmlTransient
    public Set<Announcement> getNonHistoricAnnouncements() {
        HashSet<Announcement> announcementsFiltered = new HashSet<Announcement>();
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        Date date = cal.getTime();
        if (this.announcements != null) {
            for (Announcement ann : this.announcements) {
                if (ann.getEndDisplay() != null && !date.before(ann.getEndDisplay())) continue;
                announcementsFiltered.add(ann);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Returning %d of %d announcements", this.announcements.size(), announcementsFiltered.size()));
        }
        return announcementsFiltered;
    }

    @XmlTransient
    public Set<Announcement> getHistoricAnnouncements() {
        HashSet<Announcement> announcementsFiltered = new HashSet<Announcement>();
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        Date dateStart = cal.getTime();
        if (this.announcements != null) {
            for (Announcement ann : this.announcements) {
                if (!ann.getEndDisplay().before(dateStart)) continue;
                announcementsFiltered.add(ann);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Returning %d of %d announcements", this.announcements.size(), announcementsFiltered.size()));
        }
        return announcementsFiltered;
    }

    @XmlTransient
    public int getDisplayingAnnouncementCount() {
        return this.getPublishedAnnouncements().size();
    }

    @XmlTransient
    public int getScheduledAnnouncementCount() {
        int count = 0;
        Date now = new Date();
        if (this.announcements != null) {
            for (Announcement ann : this.announcements) {
                if (!ann.getPublished().booleanValue() || !ann.getStartDisplay().after(now)) continue;
                ++count;
            }
        }
        return count;
    }

    @XmlTransient
    public Set<Announcement> getPendingAnnouncements() {
        HashSet<Announcement> announcementsFiltered = new HashSet<Announcement>();
        Date now = new Date();
        if (this.announcements != null) {
            for (Announcement ann : this.announcements) {
                if (ann.getPublished().booleanValue() || !ann.getNullSafeEndDisplay().after(now)) continue;
                announcementsFiltered.add(ann);
            }
        }
        return announcementsFiltered;
    }

    @XmlTransient
    public int getPendingAnnouncementCount() {
        int count = 0;
        if (this.announcements != null) {
            for (Announcement ann : this.announcements) {
                if (ann.getPublished().booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    @XmlTransient
    public Long getId() {
        return this.id;
    }

    public void setAnnouncements(Set<Announcement> announcements) {
        this.announcements = announcements;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @XmlElementWrapper(name="authors")
    @XmlElement(name="author")
    public Set<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(Set<String> authors) {
        this.authors = authors;
    }

    @XmlElementWrapper(name="admins")
    @XmlElement(name="admin")
    public Set<String> getAdmins() {
        return this.admins;
    }

    @XmlElementWrapper(name="audience")
    @XmlElement(name="member")
    public Set<String> getAudience() {
        return this.audience;
    }

    public void setAdmins(Set<String> admins) {
        this.admins = admins;
    }

    public void setAudience(Set<String> audience) {
        this.audience = audience;
    }

    @XmlElement(name="subscriptionMethod", required=true)
    public int getSubscriptionMethod() {
        return this.subscriptionMethod;
    }

    public void setSubscriptionMethod(int subscriptionMethod) {
        this.subscriptionMethod = subscriptionMethod;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Topic t = (Topic)obj;
        return t.getId().compareTo(this.id) == 0;
    }

    public int hashCode() {
        int code = (this.title != null ? this.title : "").hashCode();
        return code += this.id != null && this.id > 0L ? this.id.intValue() : 0;
    }

    public String toString() {
        return "Topic [allowRss=" + this.allowRss + ", creator=" + this.creator + ", description=" + this.description + ", id=" + this.id + ", moderators=" + this.moderators + ", subscriptionMethod=" + this.subscriptionMethod + ", title=" + this.title + "]";
    }
}

